/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Christian Meyer
   co-programmer: ...
*/

/*!
 * @file plane.h
 * A basic 3D plane math framework
 *
 * Contains class to handle planes
*/

#ifndef __PLANE_H_
#define __PLANE_H_

#include <math.h>
#include "compiler.h"
#include "vector.h"
#include "line.h"

//! 3D plane
/**
  Class to handle planes in 3-dimensional space

  Critical for polygon-based collision detection
*/
class Plane
{
  public:

  Vector n;   //!< Normal vector
  float k;    //!< Offset constant

  Plane (const Vector& a, const Vector& b, const Vector& c);
  Plane (const Vector& norm, const Vector& p);
  Plane (const Vector& norm, const sVec3D& p);
  Plane (const Vector& n, float k) : n(n), k(k) {} //!< assignment constructor
  Plane () : n(Vector(1,1,1)), k(0) {}
  ~Plane () {}

  Vector intersectLine (const Line& l) const;
  float distancePoint (const Vector& p) const;
  float distancePoint (const sVec3D& p) const;
  float locatePoint (const Vector& p) const;
};



//! A class that represents a rectangle, this is needed for SpatialSeparation
class Rectangle
{

  public:
    Rectangle() { this->center = Vector(); }
    Rectangle(const Vector &center, float len) { this->center = Vector(center.x, center.y, center.z); this->axis[0] = len; this->axis[1] = len; }
    virtual ~Rectangle() {}

    /** \brief sets the center of the rectangle to a defined vector @param center the new center */
   inline void setCenter(const Vector &center) { this->center = center;}
    /** \brief sets the center of the rectangle to a defined vector @param x coord of the center @param y coord of the center @param z coord of the center */
   inline void setCenter(float x, float y, float z) { this->center.x = x; this->center.y = y; this->center.z = z; }
   /** \brief returns the center of the rectangle to a defined vector @returns center the new center */
   inline const Vector& getCenter() const { return this->center; }

   /** \brief sets both axis of the rectangle to a defined vector @param unityLength the new center */
   inline void setAxis(float unityLength) { this->axis[0] = unityLength; this->axis[1] = unityLength; }
   /** \brief sets both axis of the rectangle to a defined vector @param v1 the length of the x axis @param v2 the length of the z axis*/
   inline void setAxis(float v1, float v2) { this->axis[0] = v1; this->axis[1] = v2; }
   /** \brief gets one axis length of the rectangle  @returns the length of the axis 0 */
   inline float getAxis() { return this-> axis[0]; }

  private:
    Vector          center;
    float           axis[2];
};


#endif /* __PLANE_H_ */

