/*!
 * @file physics_interface.h
  *  a physics interface simulating a body with a mass
*/

#ifndef _PHYSICS_INTERFACE_H
#define _PHYSICS_INTERFACE_H

#include "base_object.h"

#include "vector.h"
#include "quaternion.h"
#ifndef NULL
#define NULL 0          //!< NULL
#endif

// Forward Declaration
class Field;

//! A Physics interface
/**
   The PhysicsInterface is an extension to Any other object,
   that can be used to turn it to be Physcally animated.
   Still you have to connect fields.
   IMPORTANT is, that when using PNodes this baseclass is ok.
   BUT, when using any other class that does not by itself implement
   PNode you __MUST__ implement all the virtual functions by your own
*/
class PhysicsInterface : virtual public BaseObject
{
 public:
  PhysicsInterface();
  virtual ~PhysicsInterface();
  /** @param mass the mass to set for this node. */
  inline void setMass( float mass ) { this->mass = mass; };
  /** @returns the mass of the node. */
  inline float getMass( void ) const { return mass; };
  /** @returns the mass of this node plus all its children (only valid for PNodes). */
  inline float getTotalMass( void ) const { return mass + massChildren; };

  virtual void applyForce(const Vector& force);
  virtual void applyField(Field* field);
  virtual void tickPhys( float dt );

 protected:
  virtual void recalcMass();


 private:
  float          mass;                  //!< Mass of this object
  float          massChildren;          //!< Sum of the masses of the children nodes

  Vector         forceSum;              //!< Total central force for this tick
  Quaternion     momentumSum;           //!< Total momentum in this tick
  bool           bForceApplied;         //!< If a force was applied to this object.
};

#endif /* _PHYSICS_INTERFACE_H */
