/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: Patrick Boenzli : Vector2D::scale()
                                    Vector2D::abs()

   Benjamin Grauer: port to Vector2D
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_MATH

#include "vector2D.h"
#ifdef DEBUG
  #include "debug.h"
#else
  #include <stdio.h>
  #define PRINT(x) printf
#endif

using namespace std;

/////////////
/* VECTORS */
/////////////
/**
 *  returns the this-vector normalized to length 1.0
 * @todo there is some error in this function, that i could not resolve. it just does not, what it is supposed to do.
 */
Vector2D Vector2D::getNormalized() const
{
  float l = this->len();
  if(unlikely(l == 1.0 || l == 0.0))
    return *this;
  else
    return (*this / l);
}

/**
 *  Vector2D is looking in the positive direction on all axes after this
*/
Vector2D Vector2D::abs()
{
  Vector2D v(fabs(x), fabs(y));
  return v;
}



/**
 *  Outputs the values of the Vector2D
 */
void Vector2D::debug() const
{
  PRINT(0)("x: %f; y: %f", x, y);
  PRINT(0)(" lenght: %f", len());
  PRINT(0)("\n");
}
