/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer:
*/


#include "vertex_array_model.h"


#define texRate      64
#define texRatef     4.0f
#define tileSize     64

class SDL_Surface;
class Vector;
class Material;
class PNode;
class Texture;
class HeightMap;

class Tile 
{
public:
void draw();
void drawHighRes();
void drawLowRes();
int getRes();
int setHighRes(bool b);
Tile(int i1, int j1, int i2, int j2, HeightMap* hm ) ;
Tile();
~Tile();



private:
VertexArrayModel* highResModel;
VertexArrayModel* lowResModel; 
int highRes;
int lowRes;
void load(int i1, int j1, int i2, int i2, HeightMap* hm, VertexArrayModel* model, int Res);
};

class HeightMap : public VertexArrayModel
{
public:
void draw();
void load();
void load(int Mode);
void load(const char*, int Mode);
void scale( Vector V); 
void shift (Vector V);
float getHeight(float x, float y); 
HeightMap();
HeightMap(const char*);
HeightMap(const char*, const char*);
~HeightMap();

friend class Tile;

private:
SDL_Surface* heightMap;
SDL_Surface* colourMap;
unsigned char* heights; 
unsigned char* colours;

void generateNormalVectorField();
void drawRect(int xBottomLeft, int yBottomLeft, int xTopRight, int yTopRight );
void fixBoarder(int xBottomLeft, int yBottomLeft, int xTopRight, int yTopRight);
Vector  **  normalVectorField ; 
Tile    ***  tiles;
Vector     camCoords;
Material * tmp_mat;
Material* red_mat;
Texture* texture;
const PNode* camera;
float scaleX ;
float scaleY ;
float scaleZ ;
float shiftX ;
float shiftY ;
float shiftZ ;
int   cmScaleX;
int   cmScaleY;
bool  hasColourMap;

inline int abs(int val)
{
 if(val < 0) val = -val;
 return val;
}
inline int max(int x, int y)
{
 return (x>y)? x:y;
}
inline int min(int x, int y)
{
return (x<y)? x: y;
}
};
