/*!
 * @file movie_player.h
  *  Manages the media files

*/

#ifndef _MOVIE_PLAYER
#define _MOVIE_PLAYER

#include <SDL.h>

#ifdef HAVE_AVFORMAT_H
  #include <avformat.h>
#else
  #include <ffmpeg/avformat.h>
#endif

#include "glincl.h"

//#include "light.h"
#include "texture.h"
//#include "material.h"
//#include "primitive_model.h"

// include base_object.h since all classes are derived from this one
#include "base_object.h"

// The state of the MoviePlayer
typedef enum MP_STATUS {
  PLAY,
        PAUSE,
        STOP
};

class MoviePlayer : public BaseObject
{

private:

  //Model* model;
  //Material* material;

  AVFormatContext* format_context;
  AVCodecContext* codec_context;
  AVCodec* codec;
  AVFrame* frame;
  AVPacket packet;
  AVFrame* RGB_frame;

  GLuint texture;
  uint8_t* data;
  uint8_t* buffer;
  int num_bytes;
  int video_stream;

  MP_STATUS status;
  float timer;
  int start_frame;
  int actual_frame;
  int frame_number;
  float fps;
  int duration;
  bool loading;

public:

  MoviePlayer(const char* filename);
  MoviePlayer();
  ~MoviePlayer();

  bool loadMovie(const char* filename);

        void start(float start_time);
        void resume();
        void pause();
        void stop();

        void tick(float dt);
        //const void draw();
        GLuint getTexture();

        void setFPS(float fps);
        float getFPS();
        const MP_STATUS getStatus();
  void printInformation();

private:

  void init();
  void getNextFrame();
  void skipFrame(int frames);
  bool gotoFrame(int frames);

};



#endif // _MOVIE_PLAYER
