/*
  orxonox - the future of 3D-vertical-scrollers

  Copyright (C) 2004 orx

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
      the Free Software Foundation; either version 2, or (at your option)
      any later version.

### File Specific:
    main-programmer: Patrick Boenzli
    co-programmer:
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
          For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

#include "simple_sync.h"

#include "debug.h"


/**
 *  default constructor
 */
SimpleSync::SimpleSync(const char* name)
  : Synchronizeable()
{
  /* define the local buffer size */
  this->outLength = 10;
  this->recLength = 0;
  this->inLength = 40;
  this->outData = new byte[this->outLength];
  this->inData = new byte[this->inLength];

  /* init the buffer data */
  for( int i = 0; i < this->outLength; i++)
  {
    this->outData[i] = i;
  }
  for( int i = 0; i < this->inLength; i++)
  {
    this->inData[i] = 0;
  }

}


/**
 *  default destructor deletes all unneded stuff
 */
SimpleSync::~SimpleSync()
{
  if( this->outData)
    delete[] this->outData;
  if( this->inData)
    delete[] this->inData;
}


/**
 *  write data to Synchronizeable
 */
int SimpleSync::writeBytes(const byte* data, int length, int sender)
{
  PRINTF(0)("SimpleSync: got %i bytes of data\n", length);
  this->recLength = length;
  if(this->inLength < length)
    PRINTF(0)("ERROR: local buffer is smaller than the data to receive.\n");

  /* copy the data localy */
  for( int i = 0; i < length; i++)
  {
    this->inData[i] = data[i];
  }
  /* and debug output */
  this->writeDebug();
}


/**
 *  read data from Synchronizeable
 */
int SimpleSync::readBytes(byte* data, int maxLength, int * reciever)
{
  PRINTF(0)("SimpleSync: sent %i bytes of data\n", this->outLength);

  /* debug msg */
  this->readDebug();

  /* write the test message */
  for( int i = 0; i < this->outLength; i++)
    data[i] = this->outData[i];

  /* return the length of the test */
  return this->outLength;
}


void SimpleSync::writeDebug() const
{
  PRINTF(0)("Write in bytes: \t(0 <-) |");
  for(int i = 0; i < this->recLength; i++)
  {
    PRINT(0)(" [%u] ",this->inData[i]);
  }
  PRINT(0)("|\n");
}


void SimpleSync::readDebug() const
{
  PRINTF(0)("Read out bytes: \t(0 ->) |");
  for(int i = 0; i < this->outLength; i++)
  {
    PRINT(0)(" [%u] ",this->outData[i]);
  }
  PRINT(0)("|\n");
}
