/*
  orxonox - the future of 3D-vertical-scrollers

  Copyright (C) 2004 orx

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
      the Free Software Foundation; either version 2, or (at your option)
      any later version.

### File Specific:
    main-programmer: Patrick Boenzli
    co-programmer:
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
          For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

#include "read_sync.h"

#include "debug.h"


/**
 *  default constructor
 */
ReadSync::ReadSync(const char* name)
  : Synchronizeable()
{
  /* define the local buffer size */

  this->inLength = 100;
  this->recLength = 0;
  this->inData = new byte[this->inLength];

  /* init the buffer data */
  for( int i = 0; i < this->inLength; i++)
  {
    this->inData[i] = 0;
  }

}


/**
 *  default destructor deletes all unneded stuff
 */
ReadSync::~ReadSync()
{

  if( this->inData)
    delete[] this->inData;
}


/**
 *  write data to Synchronizeable
 */
int ReadSync::writeBytes(const byte* data, int length, int sender)
{
  PRINTF(0)("ReadSync: got %i bytes of data\n", length);
  this->recLength = length;
  if(this->inLength < length)
    PRINTF(0)("ERROR: local buffer is smaller than the data to receive.\n");

  /* copy the data localy */
  for( int i = 0; i < length; i++)
  {
    this->inData[i] = data[i];
  }
  /* and debug output */
  this->writeDebug();
}


/**
 *  read data from Synchronizeable
 */
int ReadSync::readBytes(byte* data, int maxLength, int * reciever)
{
  return 0;
}


void ReadSync::writeDebug() const
{
  PRINTF(0)("Write in bytes: \t(0 <-) |");
  for(int i = 0; i < this->recLength; i++)
  {
    PRINT(0)(" [%u] ",this->inData[i]);
  }
  PRINT(0)("|\n");
}


void ReadSync::readDebug() const
{}
