/*!
 * @file texture.h
 * @brief Contains the texture class, that handles the reading of Images into Texutre-files.
 */

#ifndef _TEXTURE_SEQUENCE_H
#define _TEXTURE_SEQUENCE_H

#include "texture.h"

#include "glincl.h"

#include <vector>
#include <stdarg.h>

/* Forward Declaration */
struct SDL_Surface;

//! A Class, that reads in Textures from different fileformats.
class TextureSequence : public Texture
{
  public:
    TextureSequence(unsigned int count = 0, ...);
  //  Texture(TEXTURE_TYPE type, int resolution);
    ~TextureSequence();

    bool loadImageSeries(unsigned int count, ...);
    bool loadImageSeries(unsigned int count, va_list textureNames);
    bool addFrame(const char* image);
    bool addFrame(SDL_Surface* surface);
    bool addFrame(GLuint texture);

    void clearLists();

    virtual bool rebuild();

    /** @returns the count of frames in this sequence */
    inline unsigned int getFrameCount() const { return this->textures.size(); };

    //void gotoFrame(unsigned int frameNumber);
    /** @returns The textureID of the Frame @param frameNumber the n-th frame this texture-series.  */
    inline GLuint getFrameTexture(unsigned int frameNumber) const { return (this->textures.size()>frameNumber)?this->textures[frameNumber]:0; };
    /** @returns The SDL_Surface of the image at Frame @param frameNumber the n-th frame of this image-seriers */
    const SDL_Surface* const getFrameImage(unsigned int frameNumber) const { return (this->images.size()>frameNumber)?this->images[frameNumber]:NULL; };

  private:
    std::vector<GLuint>          textures;            //!< The Texture-ID of opengl from this Texture.
    std::vector<SDL_Surface*>    images;              //!< The SDL_Surfce that stores the Texture on it.
};

#endif /* _TEXTURE_SEQUENCE_H */
