/*!
 * @file media_container.h
  *  Manages the media files

*/

#ifndef _MEDIA_CONTAINER
#define _MEDIA_CONTAINER

#include <SDL.h>

#ifdef HAVE_AVFORMAT_H
  #include <avformat.h>
#else
  #include <ffmpeg/avformat.h>
#endif

/* include base_object.h since all classes are derived from this one */
#include "base_object.h"
#include "texture_sequence.h"

#include "glincl.h"

class MediaContainer : public TextureSequence
{

private:

  AVFormatContext* format_context;
  AVCodecContext* codec_context;
  AVCodec* codec;
  AVFrame* frame;
  AVPacket packet;
  AVFrame* RGB_frame;

  GLuint texture;
  uint8_t* data;
  uint8_t* buffer;
  int num_bytes;
  int video_stream;
  double fps;

public:

  MediaContainer(const char* filename);
  MediaContainer();
  ~MediaContainer();

  bool loadMedia(const char* filename);
  void loadFrames();

  double getFPS();

private:
  
  GLuint getNextFrame();

};


#endif /* _MEDIA_CONTAINER */
