/*!
 * @file grid.h
 * @brief Definition of ...
*/

#ifndef _GRID_H
#define _GRID_H

#include "vertex_array_model.h"

// FORWARD DECLARATION



//! A class for ...
class Grid : public VertexArrayModel
{

public:
  Grid(float sizeX, float sizeY, unsigned int resolutionX, unsigned int resolutionY);
  virtual ~Grid();

  float gridSpacing() const { return this->_gridSpacingX; };
  float sizeX() const { return this->_sizeX; };
  float sizeY() const { return this->_sizeY; };
  unsigned int rows() const { return this->_rows; };
  unsigned int columns() const { return this->_columns; };

  float& height(unsigned int row, unsigned int column) { return this->vertex(row*this->_columns + column).y;};
  Vector& vertexG(unsigned int row, unsigned int column) { return this->vertex(row*this->_columns + column); };
  Vector& normalG(unsigned int row, unsigned int column) { return this->normal(row*this->_columns + column); };


  void rebuildNormals(float maxHeight);

private:
  float             _sizeX;
  float             _sizeY;

  float             _gridSpacingX;
  float             _gridSpacingY;

  unsigned int      _rows;
  unsigned int      _columns;
};

#endif /* _GRID_H */
