/*!
 * @file physics_engine.h
  *  Definition of the PhysicsEngine-singleton Class

*/

#ifndef _PHYSICS_ENGINE_H
#define _PHYSICS_ENGINE_H

#include "base_object.h"

#include "physics_connection.h"
#include "physics_interface.h"
#include "field.h"
#include <list>

// Forward Declaration
template<class T> class tList;
class TiXmlElement;

//! A class, that brings things into motion through Physics.
class PhysicsEngine : public BaseObject {

 public:
  virtual ~PhysicsEngine();
  /** @returns a Pointer to the only object of this Class */
  inline static PhysicsEngine* getInstance() { if (!singletonRef) singletonRef = new PhysicsEngine();  return singletonRef; };

  virtual void loadParams(const TiXmlElement* root);
  void loadFields(const TiXmlElement* root);
  void loadConnections(const TiXmlElement* root);

  PhysicsInterface*      getPhysicsInterfaceByName(const char* physicsInterfaceName) const;

  void                   addField(Field* field);
  void                   removeField(Field* field);
  Field*                 getFieldByName(const char* FieldName) const;

  void                   addConnection(PhysicsConnection* connection);
  void                   removeConnection(PhysicsConnection* connection);
  PhysicsConnection*     getPhysicsConnectionByName(const char* physicsConnectionName) const;


  void                   tick(float dt);

  void                   debug() const;

 private:
  PhysicsEngine();

 private:
  static PhysicsEngine*         singletonRef;         //!< the singleton reference of the PhysicsEngine

  std::list<Field*>             fields;               //!< a list of physicsl fields.
  std::list<PhysicsConnection*> connections;          //!< a list of physical connections.
  const std::list<BaseObject*>* interfaces;           //!< The list of physical interfaces.
};



#endif /* _PHYSICS_ENGINE_H */
