/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "grid.h"

using namespace std;


/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
Grid::Grid(float sizeX, float sizeY, unsigned int rows, unsigned int columns)
{
  this->planeModel(sizeX, sizeY, rows, columns);

  this->_rows = rows;
  this->_columns = columns;
  this->_sizeX = sizeX;
  this->_sizeY = sizeY;
  this->_gridSpacingX = sizeX / rows;
  this->_gridSpacingY = sizeY / columns;
}


/**
 * standard deconstructor
*/
Grid::~Grid ()
{
  // delete what has to be deleted here
}


void Grid::rebuildNormals(float maxHeight)
{
  for (unsigned int i = 1; i < this->_rows-1; i++)
  {
    for (unsigned int j = 1; j < this->_columns-1; j++)
    {
     Vector test(
          (this->vertex(i*_columns+j).y + this->vertex((i-1)*_columns+j).y - this->vertex((i+1)*_columns+j).y ) /maxHeight,
          1.0,
          (this->vertex(i*_columns+j).y - this->vertex(i*_columns+j-1).y + this->vertex(i*_columns+j+1).y)/maxHeight
                );
      this->normal( i*_columns+j) = test.getNormalized();
    }

  }

}
