/*!
 * @file vertex_array_model.h
 * @brief Contains the VertexArrayModel Class that handles 3D-Models rendered out of VertexArrays
 */

#ifndef _VERTEX_ARRAY_MODEL_H
#define _VERTEX_ARRAY_MODEL_H

#include "model.h"

#include "glincl.h"

#include <vector>

/* Forward Declaration */
class Material;


/////////////
/// MODEL ///
/////////////
//! Class that handles 3D-Models. it can also read them in and display them.
/**
 * this renders models with help of the OpenGL glVertexArray
 */
class VertexArrayModel : public Model
{
 public:
  VertexArrayModel();
  VertexArrayModel(const Model& model);
  virtual ~VertexArrayModel();

  void draw() const;


  void newStripe();

  void addVertex(float x, float y, float z);
  void addNormal(float x, float y, float z);
  void addTexCoor(float u, float v);
  void addColor(float r, float g, float b);

  void addIndice(GLuint indice);

  void finalize();

  unsigned int vertexCount() const { return this->vertices.size(); };
  unsigned int normalCount() const { return this->normals.size(); };
  unsigned int texCoordCount() const { return this->texCoords.size(); };
  unsigned int colorCount() const { return this->colors.size(); };
  unsigned int indiceCount() const { return this->indices.size(); };

  Vector& vertex(unsigned int i) { return this->vertices[i]; };
  Vector& normal(unsigned int i) { return this->normals[i]; };
  //Vector& texCoord(unsigned int i) { return this->texCoord[i]; };
  Vector& color(unsigned int i) { return this->colors[i]; };
  GLuint  index(unsigned int i) { return this->indices[i]; };
  //
  void planeModel(float sizeX, float sizeY, unsigned int resolutionX, unsigned int resolutionY);
  void spiralSphere(const float radius, const unsigned int loops, const unsigned int segmentsPerLoop);

  void debug() const;

 private:
  void importToVertexArray();

 private:
  std::vector<Vector>        vertices;        //!< The Array that handles the Vertices.
  std::vector<Vector>        normals;         //!< The Array that handles the Normals.
  std::vector<float>         texCoords;       //!< The Array that handles the VertexTextureCoordinates.
  std::vector<Vector>        colors;          //!< The Array that handles Colors.

  std::vector<GLuint>        indices;         //!< The Array that tells us what Vertex is connected to which other one.

  std::vector<GLuint>        stripes;         //!< A lsit of Stripes of this Model.

};

#endif
