/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: Patrick Boenzli
*/
#include "matrix.h"

#include <stdio.h>
#include <math.h>


int Matrix::getEigenValues(Vector& eigenValues) const
{
  int retVal = -1;
  float a = 0;
  float b = 0;

  float c[3];

  // c[0] is the determinante of mat
  c[0] = this->m11 * this->m22 * this->m33 +
      2* this->m12 * this->m13 * this->m23 -
      this->m11 * this->m23 * this->m23 -
      this->m22 * this->m13 * this->m13 -
      this->m33 * this->m12 * this->m12;

  // c[1] is the trace of a
  c[1] = this->m11 * this->m22 -
      this->m12 * this->m12 +
      this->m11 * this->m33 -
      this->m13 * this->m13 +
      this->m22 * this->m33 -
      this->m23 * this->m23;

  // c[2] is the sum of the diagonal elements
  c[2] = this->m11 +
      this->m22 +
      this->m33;


  // Computing the roots:
  a = (3.0*c[1] - c[2]*c[2]) / 3.0;
  b = (-2.0*c[2]*c[2]*c[2] + 9.0*c[1]*c[2] - 27.0*c[0]) / 27.0;

  float Q = b*b/4.0 + a*a*a/27.0;

  // 3 distinct Roots
  if (Q < 0)
  {
    float psi = atan2(sqrt(-Q), -b/2.0);
    float p = sqrt((b/2.0)*(b/2.0) - Q);

    eigenValues.x = c[2]/3.0 + 2 * pow(p, 1/3.0) * cos(psi/3.0);
    eigenValues.y = c[2]/3.0 - pow(p, 1/3.0) * (cos(psi/3.0)
        + sqrt(3.0) * sin(psi/3.0));
    eigenValues.z = c[2]/3.0 - pow(p, 1/3.0) * (cos(psi/3.0)
        - sqrt(3.0) * sin(psi/3.0));
    retVal = 3;
  }
  // 2 Distinct Roots
  else if (Q == 0)
  {
    eigenValues.x = eigenValues.y = c[2]/3.0 + pow(b/2.0, 1.0/3.0);
    eigenValues.z = c[2]/3.0 + 2* pow(b/2.0, 1.0/3.0);
    retVal = 2;
  }
  // 1 Root (not calculating anything.)
  else if (Q > 0)
  {
    eigenValues.x = eigenValues.y = eigenValues.z = 1;
    retVal = 1;
  }
  return retVal;
}




void Matrix::getEigenVectors(Vector& eigVc1, Vector& eigVc2, Vector& eigVc3) const
{
  Vector eigenValues;
  int eigenValuesCount = this->getEigenValues(eigenValues);

  if (eigenValuesCount == 2 || eigenValuesCount == 3)
  {
    /* eigenvec creation */
    eigVc1.x = -1/this->m13*(this->m33 - eigenValues.x) +
        (this->m32*(-this->m31*this->m32 + this->m12*this->m33 - this->m12*eigenValues.x)) /
        this->m13*(-this->m13*this->m22 - this->m12*this->m23 + this->m13*eigenValues.x);

    eigVc1.y = -( -this->m13*this->m23 + this->m12*this->m33 - this->m12*eigenValues.x) /
        (-this->m31*this->m22 + this->m12*this->m23 + this->m13*eigenValues.x);

    eigVc1.z = 1.0f;

    eigVc2.x = -1/this->m13*(this->m33 - eigenValues.y) +
        (this->m32*(-this->m31*this->m32 + this->m12*this->m33 - this->m12*eigenValues.y)) /
        this->m13*(-this->m13*this->m22 - this->m12*this->m23 + this->m13*eigenValues.y);

    eigVc2.y = -( -this->m13*this->m23 + this->m12*this->m33 - this->m12*eigenValues.y) /
        (-this->m31*this->m22 + this->m12*this->m23 + this->m13*eigenValues.y);

    eigVc2.z = 1.0f;

    eigVc3 = eigVc1.cross(eigVc2);

    eigVc2 = eigVc3.cross(eigVc1);
  }
  else if (eigenValuesCount == 1)
  {
    eigVc1 = Vector(1,0,0);
    eigVc2 = Vector(0,1,0);
    eigVc3 = Vector(0,0,1);
  }
  eigVc1.normalize();
  eigVc2.normalize();
  eigVc3.normalize();

  if (!(eigVc1.cross(eigVc3) == eigVc2))
  {
    eigVc3.cross(eigVc1).debug();
    eigVc2.debug();
  }
  printf("ok\n");
}

void Matrix::debug() const
{
  printf("| %f | %f | %f |\n", this->m11, this->m12, this->m13 );
  printf("| %f | %f | %f |\n", this->m21, this->m22, this->m23 );
  printf("| %f | %f | %f |\n", this->m31, this->m32, this->m33 );

}

