/*!
 * @file projectile.h
 * a projectile, that is been shooted by a weapon
 *
 * You can use this class to make some Projectiles/Bullets/Lasers/Rockets/etc.
 *
 */

#ifndef _PROJECTILE_H
#define _PROJECTILE_H

#include "world_entity.h"

class Projectile : public WorldEntity
{
  public:
    Projectile ();
    virtual ~Projectile ();

    void setFlightDirection(const Quaternion& flightDirection);
    void setVelocity(const Vector &velocity);
    void setLifeSpan(float lifeSpan);


    void setMinEnergy(float energyMin);
    /** @returns the minimal charched energy */
    inline float getMinEnergy() { return this->energyMin; };
    /** @returns if the Projectile can be charged */
    inline bool isChageable() { return this->bChargeable; };

    void setTarget(PNode* target);

    /** @brief This is called, when the Projectile is Emitted */
    virtual void activate() = 0;
    /** @brief This is called, when the Projectile is being destroyed, or deleted */
    virtual void deactivate() = 0;

    virtual void destroy ();

    virtual void tick (float dt);
    /** @brief convenience function
     * @param dt the Time passed
     * @returns true if the Projectile is past its lifeTime, false if it shall still live */
    inline bool tickLifeCycle(float dt ) { this->lifeCycle += dt/this->lifeSpan;  return(unlikely(this->lifeCycle >= 1)); }


  protected:
    // energy
    float                 energyMin;                 //!< The minimal Energy a Projectile needs to be emitted.
    bool                  bChargeable;               //!< if the Projectile is Charegeable

    float                 lifeCycle;                 //!< The percentage of the Lifetime done [0-1]
    float                 lifeSpan;                  //!< The entire lifespan of the Shoot. in seconds

    Vector                flightDirection;           //!< DOF direction in which the shoot flighs

    Vector                velocity;                  //!< velocity of the projectile.

    PNode*                target;                    //!< A target for guided Weapons.
};

#endif /* _PROJECTILE_H */
