/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Stefan Lienhard
   co-programmer: ...
*/

#include "bomb.h"
#include "glincl.h"
#include "state.h"
#include "model.h"
#include "primitive_model.h"

#include "fast_factory.h"


#include "object_manager.h"

#include "particle_engine.h"
#include "particle_emitter.h"
#include "particle_system.h"

using namespace std;

CREATE_FAST_FACTORY_STATIC(Bomb, CL_BOMB);

/**
 * constructs and loads a Bomb from a XML-element
 * @param root the XML-element to load from
 */
Bomb::Bomb(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);

  float modelSize = 1.0;
  this->loadModel("models/projectiles/RadioActiveBomb.obj", 1.0);

  this->setMinEnergy(1);
  this->setMaxEnergy(10);

  this->lifeSpan = 15;

  this->emitter = new ParticleEmitter(Vector(0,1,0), M_2_PI, 100, 5);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
}


/**
 * standard deconstructor
 */
Bomb::~Bomb ()
{
  delete this->detonationSphere;
  delete this->detonationMaterial;

}


/**
 * initializes the Bomb
 * @todo change this to what you wish
 */
void Bomb::init()
{
  this->setClassID(CL_BOMB, "Bomb");


  this->detonationSphere = new PrimitiveModel(PRIM_SPHERE);
  this->detonationMaterial = new Material();
  this->detonationMaterial->setDiffuse(1, 0, 0);
  //   this->detonationMaterial->setTransparency(.1);
  /**
   * @todo: Write CL_PROTO_WORLD_ENTITY INTO THE src/defs/class_id.h (your own definition)
   */

}


/**
 * loads a Bomb from a XML-element
 * @param root the XML-element to load from
 * @todo make the class Loadable
 */
void Bomb::loadParams(const TiXmlElement* root)
{
  // all the clases this Entity is directly derived from must be called in this way, to load all settings.
  static_cast<WorldEntity*>(this)->loadParams(root);


  /**
   * @todo: make the class Loadable
   */
}


/**
 * advances the Bomb about time seconds
 * @param time the Time to step
 */
void Bomb::tick(float time)
{
  this->lifeCycle += time/this->lifeSpan;
  if( this->lifeCycle >= 1.0)
    {
      PRINTF(5)("FINALIZE==========================\n");
      PRINTF(5)("current life cycle is: %f\n", this->lifeCycle);
      PRINTF(5)("FINALIZE===========================\n");

      this->deactivate();
    }
  else if (this->lifeCycle > 0.9f)
    this->detonate ((this->lifeCycle-.89) *1000.0);
  else
  {
    Vector v = this->velocity * (time);
    this->shiftCoor(v);
  }
}

/**
 * draws this worldEntity
 */
void Bomb::draw () const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];

  /* translate */
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
  /* rotate */
  this->getAbsDir().matrix(matrix);
  glMultMatrixf((float*)matrix);

  if (this->lifeCycle < .9)
  {
    if (this->getModel() != NULL)
      this->getModel()->draw();
  }
  else
  {
    glScalef((this->lifeCycle-.89) *1000.0,
              (this->lifeCycle-.89) *1000.0,
              (this->lifeCycle-.89) *1000.0);
    this->detonationMaterial->select();
    this->detonationSphere->draw();
  }
  glPopMatrix();
}


/**
 *
 *
 */
void Bomb::collidesWith (WorldEntity* entity, const Vector& location)
{
  if (this->lifeCycle < .9f && entity->isA(CL_NPC))
    this->lifeCycle = 0.9f;
}

void Bomb::activate()
{

}

void Bomb::deactivate()
{
  this->toList(OM_DEAD);
  this->lifeCycle = 0.0f;
  Bomb::fastFactory->kill(this);
}

void Bomb::detonate(float size)
{
  std::list<WorldEntity*>* detonationList = ObjectManager::distanceFromObject(*this, size, CL_NPC);
  if (detonationList != NULL)
  {
    while( !detonationList->empty() )
    {
      detonationList->front()->collidesWith(this, Vector(0,0,0));
      detonationList->pop_front();
    }
    delete detonationList;
  }
}
