/*!
 * @file world_entity.h
 * Definition of the basic WorldEntity
*/

#ifndef _WORLD_ENTITY_H
#define _WORLD_ENTITY_H

#include "p_node.h"
#include "synchronizeable.h"
#include "model.h"

#include "object_manager.h"
#include "glincl.h"
#include <vector>

// FORWARD DECLARATION
class SoundBuffer;
class SoundSource;
class BVTree;
class Model;

//class CharacterAttributes;


//! Basis-class all interactive stuff in the world is derived from
class WorldEntity : public PNode, public Synchronizeable
{
 public:
  WorldEntity(const TiXmlElement* root = NULL);
  virtual ~WorldEntity ();

  void loadParams(const TiXmlElement* root);

  void loadModel(const char* fileName, float scaling = 1.0f, unsigned int modelNumber = 0);
  void setModel(Model* model, unsigned int modelNumber = 0);
  Model* getModel(unsigned int modelNumber = 0) const { return (this->models.size() > modelNumber)? this->models[modelNumber] : NULL; };

  inline void loadMD2Texture(const char* fileName) { this->md2TextureFileName = fileName; }

  bool buildObbTree(unsigned int depth);
  /** @returns a reference to the obb tree of this worldentity */
  BVTree* getOBBTree() const { return this->obbTree; };

  /** @param visibility if the Entity should be visible (been draw) */
  void setVisibiliy (bool visibility) { this->bVisible = visibility; };
  /** @returns true if the entity is visible, false otherwise */
  inline bool isVisible() const { return this->bVisible; };



  virtual void postSpawn ();
  virtual void leftWorld ();

  virtual void tick (float time);

  virtual void draw () const;

  virtual void collidesWith (WorldEntity* entity, const Vector& location);
  void drawBVTree(unsigned int depth, int drawMode) const;


  void debugWE() { this->debugEntity(); };  ///FIXME
  void debugEntity() const;


  /* @returns the Count of Faces on this WorldEntity */
  //unsigned int getFaceCount () const { return (this->model != NULL)?this->model->getFaceCount():0; };
  //  void addAbility(Ability* ability);
  //  void removeAbility(Ability* ability);
  //  void setCharacterAttributes(CharacterAttributes* charAttr);
  //  CharacterAttributes* getCharacterAttributes();

  void toList(OM_LIST list);

  /** @returns a Reference to the objectListNumber to set. */
  OM_LIST& getOMListNumber() { return this->objectListNumber; }
  /** @returns a Reference to the Iterator */
  std::list<WorldEntity*>::iterator& getEntityIterator() { return this->objectListIterator; }

  int       writeState(const byte* data, int length, int sender);
  int       readState(byte* data, int maxLength );

 protected:
  //  CharacterAttributes*    charAttr;         //!< the character attributes of a world_entity


 private:
  std::vector<Model*>     models;             //!< The model that should be loaded for this entity.
  const char*             md2TextureFileName; //!< the file name of the md2 model texture, only if this
  BVTree*                 obbTree;            //!< this is the obb tree reference needed for collision detection

  bool                    bCollide;           //!< If it should be considered for the collisiontest.
  bool                    bVisible;           //!< If it should be visible.

  OM_LIST                           objectListNumber;   //!< The ObjectList from ObjectManager this Entity is in.
  std::list<WorldEntity*>::iterator objectListIterator; //!< The iterator position of this Entity in the given list of the ObjectManager.

  float                   scaling;


};

#endif /* _WORLD_ENTITY_H */
