/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Manuel Leuenberger
   co-programmer: ...
*/

#include "ground_turret.h"
#include "model.h"
#include "turret.h"

#include "factory.h"
#include "network_game_manager.h"
#include "load_param.h"

CREATE_FACTORY(GroundTurret, CL_GROUND_TURRET);

using namespace std;


/**
 * constructs and loads a GroundTurret from a XML-element
 * @param root the XML-element to load from
 */
GroundTurret::GroundTurret(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}


/**
 * standard deconstructor
 */
GroundTurret::~GroundTurret ()
{

}


/**
 * initializes the GroundTurret
 * @todo change this to what you wish
 */
void GroundTurret::init()
{
  this->setClassID(CL_GROUND_TURRET, "GroundTurret");
  this->loadModel("models/ground_turret.obj", 5);
  this->left = NULL;
  this->right = NULL;

  /*  left = new Turret();
  left->setParent(this);
  left->setRelCoor(0,10,0);
  right = new Turret();
  right->setParent(this);
  right->setRelCoor(0,10,0);*/
}


/**
 * loads a GroundTurret from a XML-element
 * @param root the XML-element to load from
 * @todo make the class Loadable
 */
void GroundTurret::loadParams(const TiXmlElement* root)
{
  // all the clases this Entity is directly derived from must be called in this way, to load all settings.
  static_cast<NPC*>(this)->loadParams(root);


  /**
   * @todo: make the class Loadable
   */
  const TiXmlElement* element;

  element = root->FirstChildElement("weapon-left");
  if (element != NULL) element = element->FirstChildElement();
  this->left = dynamic_cast<Weapon*>( Factory::fabricate( element) );
  if (this->left)
  {
    this->left->setParent(this);
    this->left->toList(this->getOMListNumber());
    this->left->setRelCoor(0,10,-5);
  }

  element = root->FirstChildElement("weapon-right");
  if (element != NULL)  if (element != NULL) element = element->FirstChildElement();
  this->right = dynamic_cast<Weapon*>( Factory::fabricate( element) );
  if (this->right)
  {
    this->right->setParent(this);
    this->right->toList(this->getOMListNumber());
    this->right->setRelCoor(0,10,5);
  }
}

/**
 * advances the GroundTurret about time seconds
 * @param time the Time to step
 */
void GroundTurret::tick(float time)
{

}

/**
 * draws this worldEntity
 */
void GroundTurret::draw () const
{
  WorldEntity::draw();

  if (this->left != NULL)
    this->left->draw();
  if (this->right != NULL)
    this->right->draw();
}


/**
 *
 *
 */
void GroundTurret::collidesWith (WorldEntity* entity, const Vector& location)
{
  if (entity->isA(CL_PROJECTILE))
    this->setAbsDirSoft(Quaternion(-90, Vector(0,0,1)), 90);
}

/**
 *
 *
 */
void GroundTurret::postSpawn ()
{

}

/**
 *
 *
 */
void GroundTurret::leftWorld ()
{

}

/**
 * Writes data from network containing information about the state
 * @param data pointer to data
 * @param length length of data
 * @param sender hostID of sender
 */
int GroundTurret::writeBytes( const byte * data, int length, int sender )
{
  setRequestedSync( false );
  setIsOutOfSync( false );

  SYNCHELP_READ_BEGIN();

  SYNCHELP_READ_FKT( WorldEntity::writeState );

  return SYNCHELP_READ_N;
}

/**
 * data copied in data will bee sent to another host
 * @param data pointer to data
 * @param maxLength max length of data
 * @return the number of bytes writen
 */
int GroundTurret::readBytes( byte * data, int maxLength, int * reciever )
{
  SYNCHELP_WRITE_BEGIN();

  if ( isOutOfSync() && !requestedSync() && this->getHostID()!=this->getOwner() )
  {
    (NetworkGameManager::getInstance())->sync( this->getUniqueID(), this->getOwner() );
    setRequestedSync( true );
  }

  int rec = this->getRequestSync();
  if ( rec > 0 )
  {
    *reciever = rec;

    SYNCHELP_WRITE_FKT( WorldEntity::readState );

  }

  *reciever = 0;
  return SYNCHELP_WRITE_N;
}
