
/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/

#include "spawning_point.h"

#include "load_param.h"
#include "factory.h"

#include "compiler.h"


/**
 *  standard constructor
 */
SpawningPoint::SpawningPoint (World* world, const Vector& absCoordinate)
{
  this->world = world;
  this->frequency = 0.5f;
  this->seed = 0.0f;

  this->init();
}


/**
 *  constructor
 */
SpawningPoint::SpawningPoint (const Vector& position, float frequency,
                              float seed, ClassID classID, World* world)
{
  this->frequency = frequency;
  this->seed = seed;
  this->classID = classID;
  this->world = world;

  this->init();
}


void SpawningPoint::init()
{
  this->countDown = 0.0f;
}


/**
 *  deconstructor
 */
SpawningPoint::~SpawningPoint ()
{}


/**
 * loads the WorldEntity Specific Parameters.
 * @param root: the XML-Element to load the Data From
 */
void SpawningPoint::loadParams(const TiXmlElement* root)
{
  /* let the world entity its stuff first */
  static_cast<WorldEntity*>(this)->loadParams(root);

  /* now load the frequency */
  LoadParam(root, "frequency", this, SpawningPoint, setSpawningFrequency)
  .describe("sets the frequency of the spawning point")
  .defaultValues(1, 1.0f);


  /* now load the seed */
  LoadParam(root, "randomseed", this, SpawningPoint, setPositionSeed)
      .describe("sets the random position seed (variance in the spawning location around the position)")
      .defaultValues(1, 0.0f);

  /* now load the seed */
/*  LoadParam(root, "classid", this, SpawningPoint, setSpawningEntity)
      .describe("sets the class id of the entity to spawn")
      .defaultValues(1, CL_WORLD_ENTITY);*/
}


/**
 *  spawn the entity
 */
void SpawningPoint::spawn()
{
  PRINTF(5)("Spangingpoint creates a new Entity (id: %i, frequency: %f, seed: %f)\n", this->classID,
            this->frequency, this->seed);
  BaseObject* spawningEntity = Factory::fabricate(this->classID);

//   if( likely(this->world != NULL))
//     this->world->spawn(dynamic_cast<WorldEntity*>(spawningEntity));
}


/**
 *  this method is called every frame
 * @param time: the time in seconds that has passed since the last tick
 *
 * Handle all stuff that should update with time inside this method (movement, animation, etc.)
 */
void SpawningPoint::tick(float dt)
{
  this->countDown += dt;
  if( this->countDown > this->frequency)
  {
    this->spawn();
    this->countDown = 0.0f;
  }
}


/**
 *  the entity is drawn onto the screen with this function
 *
 * This is a central function of an entity: call it to let the entity painted to the screen.
 * Just override this function with whatever you want to be drawn.
 */
void SpawningPoint::draw()
{}
