/*!
 * @file turret_power_up.h
 * @brief A class representing a PowerUp in the world.
*/

#ifndef _TURRET_POWER_UP_H
#define _TURRET_POWER_UP_H

#include "power_up.h"

/* FORWARD DEFINITION */
class Material;

class TurretPowerUp : public PowerUp {

 public:
  TurretPowerUp();
  TurretPowerUp(const TiXmlElement* root);
  virtual ~TurretPowerUp ();

  virtual void TurretPowerUp::collidesWith(WorldEntity* entity, const Vector& location);
  virtual void tick(float dt);
  virtual void draw() const;

  virtual int writeBytes(const byte* data, int length, int sender);
  virtual int readBytes(byte* data, int maxLength, int * reciever );

  private:
   void init();
   void loadParams(const TiXmlElement* root);

  private:
   Vector              rotation;
   float               cycle;

   Model*              sphereModel;
   Material*           sphereMaterial;
};

#endif /* _TURRET_POWER_UP_H */
