/*!
 * @file power_up.h
 * @brief A class representing a PowerUp in the world.
*/

#ifndef _POWER_UP_H
#define _POWER_UP_H

#include "world_entity.h"

class Material;

typedef enum PowerUpRespawn {
  RESPAWN_NONE,
  RESPAWN_TIME,
  RESPAWN_size
} PowerUpRespawn;

class PowerUp : public WorldEntity {

public:
  void loadParams(const TiXmlElement* root);
  void collidesWith (WorldEntity* entity, const Vector& location);

  virtual void draw () const;
  void setRespawnType(const char* type);

  int       writeState(const byte* data, int length, int sender);
  int       readState(byte* data, int maxLength );

protected:
  PowerUp(float r, float g, float b);
  virtual ~PowerUp ();
  virtual void respawn() {};

private:
  Material* sphereMaterial;
  PowerUpRespawn respawnType;
  static const char* respawnTypes[];
};

#endif /* _POWER_UP_H */
