/*!
 * @file weapon_power_up.h
 * @brief A class representing a PowerUp modifying parameters.
*/

#ifndef _PARAM_POWER_UP_H
#define _PARAM_POWER_UP_H

#include "power_up.h"

/* FORWARD DEFINITION */

typedef enum EnumParamPowerUpType {
  PARAM_SHIELD,
  PARAM_size
} EnumParamPowerUpType;

class ParamPowerUp : public PowerUp {

public:
  ParamPowerUp();
  ParamPowerUp(const TiXmlElement* root);
  virtual ~ParamPowerUp ();

  void setValue(int value);
  void setMaxValue(int value);
  void setMinValue(int value);
  void setType(const char* type);
  EnumParamPowerUpType getType();
  int getValue();

  virtual int writeBytes(const byte* data, int length, int sender);
  virtual int readBytes(byte* data, int maxLength, int * reciever );

protected:
  virtual void respawn();

private:
  void init();
  void loadParams(const TiXmlElement* root);

private:
  static const char* paramTypes[];
  EnumParamPowerUpType type;
  int value;
  int max_value;
  int min_value;
};

#endif /* _PARAM_POWER_UP_H */
