/*!
 * @file laser_power_up.h
 * @brief A class representing a PowerUp in the world.
*/

#ifndef _LASER_POWER_UP_H
#define _LASER_POWER_UP_H

#include "power_up.h"

/* FORWARD DEFINITION */
class Material;

class LaserPowerUp : public PowerUp {

 public:
  LaserPowerUp();
  LaserPowerUp(const TiXmlElement* root);
  virtual ~LaserPowerUp ();

  virtual void LaserPowerUp::collidesWith(WorldEntity* entity, const Vector& location);
  virtual void tick(float dt);
  virtual void draw() const;

  virtual int writeBytes(const byte* data, int length, int sender);
  virtual int readBytes(byte* data, int maxLength, int * reciever );

  private:
   void init();
   void loadParams(const TiXmlElement* root);

  private:
   Vector              rotation;
   float               cycle;

   Model*              sphereModel;
   Material*           sphereMaterial;
};

#endif /* _LASER_POWER_UP_H */
