/*!
 * @file game_loader.h
 *  loads campaigns, worlds and all other story_entities
*/

#ifndef _GAME_LOADER_H
#define _GAME_LOADER_H

//#include "stdincl.h"
#include "story_def.h"
#include "comincl.h"
#include "event_listener.h"

#include "error.h"

//-----------------------------------------------------------------------------
// Forward declarations
//-----------------------------------------------------------------------------
class Campaign;
class World;
class Factory;
class TiXmlElement;
class BaseObject;
class Event;
class EventHandler;

//! The GameLoader
/**
 *  The game loader loads all game date. this is performed in the following way:
 * 1. Read the structure of campaings and worlds
 * 2. Create the instances of the tree: here _ALL_ StoryEntities are created
 *    also if they are not yet used. the worlds should load their data in
 *    the StoryEntity::load() and StoryEntity::init() functions! NOWHERE ELSE!
 *    Elsewhere, all the data will be allocated at the beginning... mess...
 * 3. StoryEntities are load() and init() before they start
 * 4. once the gamloader starts the game there will be a campaing starting a
 *    world. this is done by callaing those StoryEntity::start()
*/
class GameLoader : public EventListener
{
 public:
  ~GameLoader ();
  /**  this class is a singleton class @returns an instance of itself  */
  static GameLoader* getInstance() { if(singletonRef == NULL) singletonRef = new GameLoader(); return singletonRef; }

  ErrorMessage loadCampaign(const char* name);
  ErrorMessage loadDebugCampaign(Uint32 campaignID);
  ErrorMessage loadNetworkCampaign(const char* fileName);

  ErrorMessage init();
  ErrorMessage start();
  void stop();
  ErrorMessage pause();
  ErrorMessage resume();

  void switchToNextLevel();

  void process(const Event &event);


 private:
  GameLoader ();

  Campaign* fileToCampaign(const char* name);


 private:
  static GameLoader*     singletonRef;         //!< The singleton-reference to this object

  Uint32                 startTime;            //!< start time of the campaign
  bool                   isPaused;             //!< if the game is paused

  Campaign*              currentCampaign;      //!< reference to the current campaign playing

  EventHandler*          eventHandler;         //!< reference to the eventHandler
};

#endif /* _GAME_LOADER_H */
