
#include "stdlibincl.h"
#include <stdarg.h>
#include <stdio.h>
#include "shell_buffer.h"
#include "class_list.h"

#include "network_manager.h"
#include "network_socket.h"
#include "server_socket.h"
#include "network_stream.h"
#include "synchronizeable.h"
#include "converter.h"

#include "simple_sync.h"
#include "read_sync.h"

int verbose = 4;


/* outputs the help */
int startHelp(int argc, char** argv)
{
  printf("Network is a network unit test\n");
  printf(" --help                     this output\n");
  printf(" -st,  --sockettest         test network_socket\n");
  printf(" -ft,  --frameworktest      test the network module\n");
  printf(" --server [port number]     creates a test server\n");
  printf(" --client [address] [port]  connects to a server\n");
  printf(" --listen [address] [port]  just listens to this connection");
  printf("\n");
}


/* test SDL network socket */
int testSocket(int argc, char** argv)
{
  IPaddress ip;
  SDLNet_ResolveHost(&ip, "127.0.0.1", 9999);
  ServerSocket server;
  server.listen(9999);

  NetworkSocket* client1 = new NetworkSocket(ip);

  NetworkSocket* server1 = server.getNewSocket();

  NetworkSocket* client2 = new NetworkSocket(ip);

  NetworkSocket* server2 = server.getNewSocket();

  char buf[1024];

  printf("read from client1 before sending data\n");
  printf("result: %d bytes\n", client1->readPacket((byte*)buf, 1024));

  printf("read from client2 before sending data\n");
  printf("result: %d bytes\n", client2->readPacket((byte*)buf, 1024));

  int n;
  char * str1 = "client1 to server";
  char * str2 = "server1 to client";
  char * str3 = "client2 to server";
  char * str4 = "server2 to client";
  n = client1->writePacket((byte*)str1, strlen(str1)+1);
  printf("%d bytes send from client1\n", n);
  n = server1->writePacket((byte*)str2, strlen(str2)+1);
  printf("%d bytes send from server1\n", n);
  n = client2->writePacket((byte*)str3, strlen(str3)+1);
  printf("%d bytes send from client2\n", n);
  n = server2->writePacket((byte*)str4, strlen(str4)+1);
  printf("%d bytes send from server2\n", n);
  SDL_Delay(1000);

  printf("read from server1\n");
  n = server1->readPacket((byte*)buf, 1024);
  printf("read %d bytes\n", n);
  if (n<0)
    return -1;

  printf("data: '%s'\n", buf);

  printf("read from server2\n");
  n = server2->readPacket((byte*)buf, 1024);
  printf("read %d bytes\n", n);
  if (n<0)
    return -1;

  printf("data: '%s'\n", buf);

  printf("read from client1\n");
  n = client1->readPacket((byte*)buf, 1024);
  printf("read %d bytes\n", n);
  if (n<0)
    return -1;

  printf("data: '%s'\n", buf);

  printf("read from client2\n");
  n = client2->readPacket((byte*)buf, 1024);
  printf("read %d bytes\n", n);
  if (n<0)
    return -1;

  printf("data: '%s'\n", buf);

  //sending bigger packets than 255 is not supported

  printf("try to send more than 255 bytes\n");
  printf("result: %d\n", client1->writePacket((byte*)buf, 1000));

  server1->writePacket((byte*)str1, strlen(str1)+1);
  SDL_Delay(500);
  printf("try to read with a too small buffer\n");
  printf("result: %d\n", client1->readPacket((byte*)buf, strlen(str1)));

  return 0;
}


int testFramework(int argc, char** argv)
{
  printf("=================\n");
  printf("TestFramework\n");
  printf("=================\n");

  Synchronizeable* clientSync = new SimpleSync("Client\0");
  Synchronizeable* serverSync = new SimpleSync("Server\0");

  unsigned int port = 9999;

  /* create the network manager */
  NetworkManager* nm = NetworkManager::getInstance();

  /* initialize the network manager */
  nm->initialize();

  /* create a server stream */
  nm->createServer(port);

  /* esatblish a connection */
  IPaddress ip;
  int error = SDLNet_ResolveHost(&ip, "127.0.0.1", port);
  //SDLNet_ResolveHost(&ip, "localhost", port);
  if(error == -1)
    printf("\n\nerror on address resolution, program inconsistancy\n\n");
  nm->establishConnection(ip, *clientSync);
  /* adding some break for connection setup */
  SDL_Delay(20);

  /* synchronize the data 1 time (increment for longer tests) */
  for( int i = 0; i < 3; i++)
  {
    nm->synchronize();
    /* simulate the network delay */
    SDL_Delay(50);
  }

  printf("Test finished\n");


  /* delete the network manager again */
  delete nm;

  delete clientSync;
  delete serverSync;

  return 0;
}



/**
 *
 * @param argc
 * @param argv
 * @return
 */
int startServer(int argc, char** argv)
{
  if( argc <= 2)
  {
    printf(" Wrong arguments try following notations:\n");
    printf("   --server [port number]\n");
    return 0;
  }

  int port = atoi(argv[2]);
  printf("Starting Server on port %i\n", port);

  NetworkManager* netMan = NetworkManager::getInstance();
  Synchronizeable* ss = new SimpleSync("Server\0");

  netMan->createServer(/**ss, */port);
  SDL_Delay(20);

  for(;;)
  {
    netMan->synchronize();
    SDL_Delay(1000);
  }

  delete netMan;
  delete ss;


  return 0;
}


int startClient(int argc, char** argv)
{
  if( argc < 3)
  {
    printf(" Wrong arguments try following notations:\n");
    printf("   --client [server ip] [port number]\n");
    printf("   --client [server name] [port number]\n");
    return 0;
  }

  char* name = argv[2];
  int port = atoi(argv[3]);
  printf("Connecting to %s, on port %i\n", name, port);

  IPaddress ip;
  int error = SDLNet_ResolveHost(&ip, name, port);
  if(error == -1)
    printf("\n\nerror on address resolution, program inconsistancy\n\n");

  NetworkManager* netMan = NetworkManager::getInstance();
  Synchronizeable* ss = new SimpleSync("Client\0");

  netMan->establishConnection((const char*)"localhost", port/*,ip, *ss*/);

  for(;;)
  {
    netMan->synchronize();
    SDL_Delay(500);
  }


  delete netMan;
  delete ss;

  return 0;
}



int startListen(int argc, char** argv)
{
  if( argc < 3)
  {
    printf(" Wrong arguments try following notations:\n");
    printf("   --listen [server ip] [port number]\n");
    printf("   --listen [server name] [port number]\n");
    return 0;
  }

  char* name = argv[2];
  int port = atoi(argv[3]);
  printf("Connecting to %s, on port %i\n", name, port);

  IPaddress ip;
  int error = SDLNet_ResolveHost(&ip, name, port);
  if(error == -1)
    printf("\n\nerror on address resolution, program inconsistancy\n\n");

  NetworkManager* netMan = NetworkManager::getInstance();
  Synchronizeable* ss = new ReadSync("WriteSync\0");

  netMan->establishConnection(ip, *ss);

  for(;;)
  {
    netMan->synchronize();
    SDL_Delay(10);
  }


  delete netMan;
  delete ss;

  return 0;
}

void testFloatConverter(float f)
{
  char* s = Converter::floatToBinString(f);
  printf("%f = ", f);
  printf(s); printf("\n");

  byte* res = Converter::floatToByteArray(f);
  printf("Byte Array: ");
  for (int i = 0; i < 4; i++)
    printf("%i  ", res[i]);
  printf("\n");

  float b = Converter::byteArrayToFloat(res);
  printf("ReConvert: %f \n", b);
}

void testFloatConverter2(float f)
{
  char* s = Converter::floatToBinString(f);
  printf("### %f = ", f);
  printf(s); printf("\n");

  byte* res = Converter::_floatToByteArray(f);
  printf("Byte Array: ");
  for (int i = 0; i < 4; i++)
    printf("%i  ", res[i]);
  printf("\n");

  float b = Converter::_byteArrayToFloat(res);
  printf("ReConvert: %f \n", b);
}
int converter(int argc, char** argv)
{
  /*
  int x = 200564786;
  printf("To convert: %i\n", x);
  byte* res = Converter::intToByteArray(x);
  for (int i = 0; i < 4; i++)
    printf("%i  ", res[i]);
  printf("\n");

  int z = Converter::byteArrayToInt(res);

  printf("ReConvert: %i\n", z);


  //float a = 5.4f;
  //float b = 2.0f;
  //printf("%f mod %f = %f", a, b, a % b);

  printf("\n");

  */
  /*
  float y;
  char* s;

  y = 12.0f;
  s = Converter::floatToBinString(y);
  printf("%f = ", y);
  printf(s); printf("\n");

  y = 24549026.0f;
  s = Converter::floatToBinString(y);
  printf("%f = ", y);
  printf(s); printf("\n");

  y = 12.4e20f;
  s = Converter::floatToBinString(y);
  printf("%f = ", y);
  printf(s); printf("\n");

  y = 4.7824f;
  s = Converter::floatToBinString(y);
  printf("%f = ", y);
  printf(s); printf("\n");

  y = -4.7824f;
  s = Converter::floatToBinString(y);
  printf("%f = ", y);
  printf(s); printf("\n");

  y = -14.35e14f;
  s = Converter::floatToBinString(y);
  printf("%f = ", y);
  printf(s); printf("\n");
                                                            */


  /*
  float a = 12.3f;

  char* s = Converter::floatToBinString(a);
  printf("%f = ", a);
  printf(s); printf("\n");

  byte* res = Converter::floatToByteArray(a);
  printf("Byte Array: \n");
  for (int i = 0; i < 4; i++)
    printf("%i  ", res[i]);
  printf("\n");

  float b = Converter::byteArrayToFloat(res);
  printf("ReConvert: %f \n", b);
  */
//  testFloatConverter(12.3e-53f); printf("\n");
//  testFloatConverter(134.26455646546548741661675165f); printf("\n");
 // testFloatConverter(35.67e14f); printf("\n");

  testFloatConverter(12.3e-7f); printf("\n");
  testFloatConverter(134.26455646546548741661675165f); printf("\n");
  testFloatConverter(35.67e14f); printf("\n");

  return 0;
}



/**
 *
 *  main function
 *
 * here the journey begins
 */
int main(int argc, char** argv)
{
  int i;
  // here the pre-arguments are loaded, these are needed to go either to orxonx itself, Help, or Benchmark.
  for(i = 1; i < argc; ++i)
  {
    //else if(!strcmp( "--gui", argv[i]) || !strcmp("-g", argv[i])) showGui = true;
    if (! strcmp( "--sockettest", argv[i]) || !strcmp("-st", argv[i]))
      return testSocket(argc, argv);
    else if (! strcmp( "--frameworktest", argv[i]) || !strcmp("-ft", argv[i]))
      return testFramework(argc, argv);
    else if (! strcmp( "--server", argv[i]) || !strcmp("-s", argv[i]))
      return startServer(argc, argv);
    else if (! strcmp( "--client", argv[i]) || !strcmp("-c", argv[i]))
      return startClient(argc, argv);
    else if (! strcmp( "--listen", argv[i]) || !strcmp("-l", argv[i]))
      return startListen(argc, argv);
    else if (! strcmp( "--converter", argv[i]) || !strcmp("-o", argv[i]))
      return converter(argc, argv);
  }

  startHelp(argc, argv);

  return 0;
}


bool ShellBuffer::addBufferLineStatic(const char* line, ...)
{
  //va_list arguments;
  //vprintf(line, arguments);
  printf("%s", line);
}
