

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD


#include "story_entity.h"

#include "load_param.h"


using namespace std;


/**
 *  default constructor initializes all needed data
 */
StoryEntity::StoryEntity ()
{
  this->setClassID(CL_STORY_ENTITY, "StoryEntity");

  this->isInit = false;
  this->isPaused = false;
  this->isRunning = false;

  this->storyID = -1;
  this->nextStoryID = WORLD_ID_GAMEEND;
}


/**
 *  deconstructor
 */
StoryEntity::~StoryEntity ()
{}


/**
 *  loads the Parameters of a Campaign
 * @param root: The XML-element to load from
 */
void StoryEntity::loadParams(const TiXmlElement* root)
{
  static_cast<BaseObject*>(this)->loadParams(root);

  LoadParam(root, "identifier", this, StoryEntity, setStoryID)
      .describe("A Unique Identifier for this StoryEntity");

  LoadParam(root, "nextid", this, StoryEntity, setNextStoryID)
      .describe("Sets the ID of the next StoryEntity");

  PRINTF(4)("Loaded StoryEntity specific stuff\n");
}
