/*!
 * @file single_player_world_data.h
 *  container for all singleplayer game world data
 */

#ifndef _SINGLE_PLAYER_WORLD_DATA_H
#define _SINGLE_PLAYER_WORLD_DATA_H


#include "game_world_data.h"


class TiXmlElement;


//! The singleplayer world data
class SinglePlayerWorldData : public GameWorldData
{

  public:
    SinglePlayerWorldData();
    virtual ~SinglePlayerWorldData();

    virtual ErrorMessage init();


  protected:
    virtual ErrorMessage loadGUI(TiXmlElement* root);
    virtual ErrorMessage loadWorldEntities(TiXmlElement* root);
    virtual ErrorMessage loadScene(TiXmlElement* root);

    virtual ErrorMessage unloadGUI();
    virtual ErrorMessage unloadWorldEntities();
    virtual ErrorMessage unloadScene();
};

#endif /* _SINGLE_PLAYER_WORLD_DATA_H */
