/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD


#include "single_player_world_data.h"

#include "load_param.h"


using namespace std;


/**
 * constructor of the GameWorldDataData
 */
SinglePlayerWorldData::SinglePlayerWorldData()
  : GameWorldData()
{}


/**
 * destructor for the GameWorldDataData
 */
SinglePlayerWorldData::~SinglePlayerWorldData()
{}


/**
 *  initialize the GameWorldDataData
 */
ErrorMessage SinglePlayerWorldData::init()
{
  /* call underlying function */
  GameWorldData::init();
}


/**
 *  loads the GUI data
 * @param root reference to the xml root element
 */
ErrorMessage SinglePlayerWorldData::loadGUI(TiXmlElement* root)
{
  /* call underlying function */
  GameWorldData::loadGUI(root);
}


/**
 *  unloads the GUI data
 */
ErrorMessage SinglePlayerWorldData::unloadGUI()
{
  /* call underlying function */
  GameWorldData::unloadGUI();
}


/**
 *  overloads the GameWorld::loadWorldEntities(...) class since the network WorldEntity loading is different
 * @param root reference to the xml root parameter
 */
ErrorMessage SinglePlayerWorldData::loadWorldEntities(TiXmlElement* root)
{
  /* call underlying function */
  GameWorldData::loadWorldEntities(root);
}


/**
 *  unloads the world entities from the xml file
 */
ErrorMessage SinglePlayerWorldData::unloadWorldEntities()
{
  /* call underlying function */
  GameWorldData::unloadWorldEntities();
}


/**
 *  loads the scene data
 * @param root reference to the xml root element
 */
ErrorMessage SinglePlayerWorldData::loadScene(TiXmlElement* root)
{
  /* call underlying function */
  GameWorldData::loadScene(root);
}


/**
 *  unloads the scene data
 */
ErrorMessage SinglePlayerWorldData::unloadScene()
{
  /* call underlying function */
  GameWorldData::unloadScene();
}

