/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD


#include "single_player_world.h"
#include "single_player_world_data.h"

#include "state.h"
#include "class_list.h"

#include "load_param.h"
#include "fast_factory.h"
#include "factory.h"

#include "world_entity.h"
#include "npcs/npc_test1.h"


using namespace std;


//! This creates a Factory to fabricate a SinglePlayerWorld
CREATE_FACTORY(SinglePlayerWorld, CL_SINGLE_PLAYER_WORLD);



SinglePlayerWorld::SinglePlayerWorld(const TiXmlElement* root)
  : GameWorld(root)
{
  this->setClassID(CL_SINGLE_PLAYER_WORLD, "SinglePlayerWorld");
  this->setName("SinglePlayerWorld uninitialized");

  this->dataTank = new SinglePlayerWorldData();

  this->loadParams(root);
}


/**
 *  remove the SinglePlayerWorld from memory
 *
 *  delete everything explicitly, that isn't contained in the parenting tree!
 *  things contained in the tree are deleted automaticaly
 */
SinglePlayerWorld::~SinglePlayerWorld ()
{
  PRINTF(3)("SinglePlayerWorld::~SinglePlayerWorld() - deleting current world\n");

  if( this->dataTank)
    delete this->dataTank;
}


/**
 * loads the parameters of a SinglePlayerWorld from an XML-element
 * @param root the XML-element to load from
 */
void SinglePlayerWorld::loadParams(const TiXmlElement* root)
{
  static_cast<GameWorld*>(this)->loadParams(root);

  PRINTF(4)("Loaded SinglePlayerWorld specific stuff\n");
}

