/*!
 * @file multi_player_world_data.h
 *  container for all multiplayer game world data
 */

#ifndef _MULTI_PLAYER_WORLD_DATA_H
#define _MULTI_PLAYER_WORLD_DATA_H


#include "game_world_data.h"


class TiXmlElement;


//! The multiplayer world data
class MultiPlayerWorldData : public GameWorldData
{

  public:
    MultiPlayerWorldData();
    virtual ~MultiPlayerWorldData();

    virtual ErrorMessage init();


  protected:
    virtual ErrorMessage loadGUI(TiXmlElement* root);
    virtual ErrorMessage loadWorldEntities(TiXmlElement* root);
    virtual ErrorMessage loadScene(TiXmlElement* root);

    virtual ErrorMessage unloadGUI();
    virtual ErrorMessage unloadWorldEntities();
    virtual ErrorMessage unloadScene();
};

#endif /* _MULTI_PLAYER_WORLD_DATA_H */
