/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD


#include "multi_player_world_data.h"

#include "resource_manager.h"
#include "state.h"
#include "class_list.h"
#include "substring.h"

#include "game_loader.h"
#include "cd_engine.h"

#include "p_node.h"
#include "world_entity.h"
#include "player.h"
#include "camera.h"
#include "environment.h"
#include "terrain.h"
#include "test_entity.h"
#include "terrain.h"
#include "md2Model.h"
#include "weapons/projectile.h"
#include "npcs/npc_test1.h"
#include "playable.h"

#include "factory.h"
#include "fast_factory.h"
#include "load_param.h"

#include "network_manager.h"
#include "network_game_manager.h"


#include "glmenu_imagescreen.h"


using namespace std;


/**
 * constructor of the GameWorldDataData
 */
MultiPlayerWorldData::MultiPlayerWorldData()
    : GameWorldData()
{}


/**
 * destructor for the GameWorldDataData
 */
MultiPlayerWorldData::~MultiPlayerWorldData()
{}


/**
 *  initialize the GameWorldDataData
 */
ErrorMessage MultiPlayerWorldData::init()
{
  /* call underlying function */
  GameWorldData::init();
}


/**
 *  loads the GUI data
 * @param root reference to the xml root element
 */
ErrorMessage MultiPlayerWorldData::loadGUI(TiXmlElement* root)
{
  /* call underlying function */
  GameWorldData::loadGUI(root);
}


/**
 *  unloads the GUI data
 */
ErrorMessage MultiPlayerWorldData::unloadGUI()
{
  /* call underlying function */
  GameWorldData::unloadGUI();
}


/**
 *  overloads the GameWorld::loadWorldEntities(...) class since the network WorldEntity loading is different
 * @param root reference to the xml root parameter
 */
ErrorMessage MultiPlayerWorldData::loadWorldEntities(TiXmlElement* root)
{
  /* load the spawning points */
  TiXmlElement* element = root->FirstChildElement("SpawningPoints");
  if( element == NULL)
  {
    PRINTF(1)("NetworkWorld is missing 'SpawningPoints'\n");
  }
  else
  {
    element = element->FirstChildElement();
    // load Players/Objects/Whatever
    PRINTF(4)("Loading Spawning Points\n");
    while( element != NULL)
    {
      BaseObject* created = Factory::fabricate(element);
      if( created != NULL )
        printf("Created a Spawning Point %s: %s\n", created->getClassName(), created->getName());

      element = element->NextSiblingElement();
      glmis->step();
    }
    PRINTF(4)("Done loading Spawning Points\n");
  }

  /* load the WorldEntities */
  element = root->FirstChildElement("WorldEntities");
  if( element == NULL)
  {
    PRINTF(1)("NetworkWorld is missing 'WorldEntities'\n");
  }
  else
  {
    element = element->FirstChildElement();

    while( element != NULL)
    {
      if( NetworkManager::getInstance()->isGameServer())
      {
        /* pass the entity to the NetworkGameManager to be created */
        BaseObject* created = NetworkGameManager::getInstance()->createEntity(element);
        if( created != NULL )
          PRINTF(1)("Created a %s: %s (0x%8x) from %s\n", created->getClassName(), created->getName(), created->getLeafClassID(), element->Value());
        else
          PRINTF(1)("NetworkWorld: could not create this entity\n");

        if( element->Value() != NULL && !strcmp( element->Value(), "SkyBox"))
          this->sky = dynamic_cast<WorldEntity*>(created);
        if( element->Value() != NULL && !strcmp( element->Value(), "Terrain"))
        {
          this->terrain = dynamic_cast<Terrain*>(created);
          CDEngine::getInstance()->setTerrain(terrain);
        }
      }
      /* clients only spawn the SpaceShip */
      /// FIXME it is not said to be a SpaceShip
      else if( !strcmp( element->Value(), "SpaceShip"))
      {
        BaseObject* created = Factory::fabricate(element);
        if( created != NULL )
          PRINTF(1)("Created a %s: %s (%8.u)\n", created->getClassName(), created->getName(), created->getLeafClassID());
        else
          PRINTF(1)("NetworkWorld: could not create this entity\n");
      }
      element = element->NextSiblingElement();

      glmis->step();
      PRINTF(4)("Done loading NetworkWorldEntities\n");
    }


    /* create a Player */
    this->localPlayer = new Player();
    Playable* playable;
    const list<BaseObject*>* playableList = ClassList::getList(CL_PLAYABLE);
    if (playableList != NULL)
    {
      playable = dynamic_cast<Playable*>(playableList->front());
      this->localPlayer->setControllable(playable);
    }


    /* init the pnode tree */
    PNode::getNullParent()->init();
  }
}


/**
 *  unloads the world entities from the xml file
 */
ErrorMessage MultiPlayerWorldData::unloadWorldEntities()
{
  /* call underlying function */
  GameWorldData::unloadWorldEntities();
}


/**
 *  loads the scene data
 * @param root reference to the xml root element
 */
ErrorMessage MultiPlayerWorldData::loadScene(TiXmlElement* root)
{
  /* call underlying function */
  GameWorldData::loadScene(root);
}


/**
 *  unloads the scene data
 */
ErrorMessage MultiPlayerWorldData::unloadScene()
{
  /* call underlying function */
  GameWorldData::unloadScene();
}

