/*!
 * @file multi_player_world.h
  *  Holds and manages all game data
*/

#ifndef _MULTI_PLAYER_WORLD_H
#define _MULTI_PLAYER_WORLD_H

#include "game_world.h"


class TiXmlElement;
class MultiPlayerWorldData;


//! The multiplayer game world
/**
 *  this class initializes everything that should be displayed inside of the current level.
 *  it is the main driving factor during gameplay.
 */
class MultiPlayerWorld : public GameWorld {

 public:
  MultiPlayerWorld (const TiXmlElement* root = NULL);
  virtual ~MultiPlayerWorld ();

  void loadParams(const TiXmlElement* root);

  protected:
    virtual void synchronize();
};

#endif /* _MULTI_PLAYER_WORLD_H */
