/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD


#include "multi_player_world.h"
#include "multi_player_world_data.h"

#include "factory.h"
#include "load_param.h"

#include "network_manager.h"


using namespace std;


//! This creates a Factory to fabricate a MultiPlayerWorld
CREATE_FACTORY(MultiPlayerWorld, CL_MULTI_PLAYER_WORLD);


MultiPlayerWorld::MultiPlayerWorld(const TiXmlElement* root)
  : GameWorld(root)
{
  this->setClassID(CL_MULTI_PLAYER_WORLD, "MultiPlayerWorld");

  this->dataTank = new MultiPlayerWorldData();

  this->loadParams(root);
}


/**
 *  remove the MultiPlayerWorld from memory
 *
 *  delete everything explicitly, that isn't contained in the parenting tree!
 *  things contained in the tree are deleted automaticaly
 */
MultiPlayerWorld::~MultiPlayerWorld ()
{
  PRINTF(3)("MultiPlayerWorld::~MultiPlayerWorld() - deleting current world\n");
  if( this->dataTank)
    delete this->dataTank;
}


/**
 * loads the parameters of a MultiPlayerWorld from an XML-element
 * @param root the XML-element to load from
 */
void MultiPlayerWorld::loadParams(const TiXmlElement* root)
{
  static_cast<GameWorld*>(this)->loadParams(root);

  PRINTF(4)("Creating a MultiPlayerWorld\n");
}


/**
 *  synchronizes the network since this is a network world
 *
 * this function overrides the synchrinize from the GameWorld
 */
void MultiPlayerWorld::synchronize()
{
  NetworkManager::getInstance()->synchronize();
}

