/*!
 * @file game_world_data.h
 *  container for all game world data
 */

#ifndef _GAME_WORLD_DATA_H
#define _GAME_WORLD_DATA_H

#include "sdlincl.h"
#include "data_tank.h"
#include "error.h"


class Camera;
class Player;
class Terrain;
class WorldEntity;
class ObjectManager;

class GLMenuImageScreen;

class TiXmlElement;
class OggPlayer;


//! The game world data
/**
 * this class is a containter for the data of the GameWorld. It just loads and unloads it
 * the game start/stop process is not contained here and can be found in the GameWorld class.
 */
class GameWorldData : public DataTank
{

  public:
    GameWorldData();
    virtual ~GameWorldData();

    virtual ErrorMessage init();
    virtual ErrorMessage loadData(TiXmlElement* root);
    virtual ErrorMessage unloadData();


  protected:
    virtual ErrorMessage loadGUI(TiXmlElement* root);
    virtual ErrorMessage loadWorldEntities(TiXmlElement* root);
    virtual ErrorMessage loadScene(TiXmlElement* root);

    virtual ErrorMessage unloadGUI();
    virtual ErrorMessage unloadWorldEntities();
    virtual ErrorMessage unloadScene();


  public:
    GLMenuImageScreen*  glmis;                       //!< The Level-Loader Display

    Camera*             localCamera;                 //!< The current camera
    Player*             localPlayer;                 //!< The player, you fly through the level.
    WorldEntity*        sky;                         //!< The environmental sky of orxonox
    Terrain*            terrain;                     //!< The terrain - ground

    OggPlayer*          music;                       //!< Reference to the SoundEngine's music player (OggPlayer)
    ObjectManager*      objectManager;               //!< Reference to the objects manager
};

#endif /* _GAME_WORLD_DATA_H */

