/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD

#include "dedicated_server_world.h"

#include "state.h"
#include "class_list.h"

#include "load_param.h"
#include "fast_factory.h"
#include "factory.h"

#include "world_entity.h"
#include "npcs/npc_test1.h"


using namespace std;

//! This creates a Factory to fabricate a DedicatedServerWorld
CREATE_FACTORY(DedicatedServerWorld, CL_DEDICATED_SERVER_WORLD);



DedicatedServerWorld::DedicatedServerWorld(const TiXmlElement* root)
  : GameWorld(root)
{
  this->setClassID(CL_DEDICATED_SERVER_WORLD, "DedicatedServerWorld");
  this->setName("DedicatedServerWorld uninitialized");

  this->loadParams(root);
}


/**
 *  remove the DedicatedServerWorld from memory
 *
 *  delete everything explicitly, that isn't contained in the parenting tree!
 *  things contained in the tree are deleted automaticaly
 */
DedicatedServerWorld::~DedicatedServerWorld ()
{
  PRINTF(3)("DedicatedServerWorld::~DedicatedServerWorld() - deleting current world\n");
}


/**
 * loads the parameters of a DedicatedServerWorld from an XML-element
 * @param root the XML-element to load from
 */
void DedicatedServerWorld::loadParams(const TiXmlElement* root)
{
  static_cast<GameWorld*>(this)->loadParams(root);

  PRINTF(4)("Loaded DedicatedServerWorld specific stuff\n");
}

