/*!
 * @file campaign_data.h
 * definition of the campaign data tank
 */

#ifndef _CAMPAIGN_DATA_H
#define _CAMPAIGN_DATA_H


#include "data_tank.h"
#include <list>

class StoryEntity;

//! A class that contains the data of the Campaign object
class CampaignData : public DataTank
{

  public:
    CampaignData(const TiXmlElement* root);
    virtual ~CampaignData();

    void loadParams(const TiXmlElement* root);

    void loadData(const TiXmlElement* root);

    void addStoryEntity(StoryEntity* se);

    StoryEntity* getFirstLevel();
    StoryEntity* getNextLevel();


  private:
    StoryEntity*                  currentEntity;                //!< reference to the currently used StoryEntity
    std::list<StoryEntity*>       storyEntities;                //!< list of story entities
};


#endif /* _CAMPAIGN_DATA_H */

