/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/


#include "campaign_data.h"

#include "factory.h"
#include "load_param.h"

#include "story_entity.h"


using namespace std;


/**
 * constructor for CampaignData
 */
CampaignData::CampaignData(const TiXmlElement* root)
{
  this->setClassID(CL_CAMPAIGN_DATA, "CampaignData");

  this->currentEntity = NULL;

  this->loadParams(root);
}


/**
 * destructor for CampaignData
 */
CampaignData::~CampaignData()
{
  PRINTF(4)("Deleting CampaignData\n");
  while( !this->storyEntities.empty())
  {
    StoryEntity* bo = this->storyEntities.back();
    this->storyEntities.pop_back();
    PRINTF(4)("CampaignData is been deleted: nr %i\n", bo->getStoryID());
    delete bo;
  }
}


/**
 *  loads the Parameters of a Campaign
 * @param root: The XML-element to load from
 */
void CampaignData::loadParams(const TiXmlElement* root)
{
  LoadParamXML(root, "WorldList", this, CampaignData, loadData)
      .describe("A List of Worlds to be loaded in this Campaign");
}


/**
 *  loads a WorldList
 * @param root: the XML-element to load from
 */
void CampaignData::loadData(const TiXmlElement* root)
{
  if( root == NULL)
    return;

  LOAD_PARAM_START_CYCLE(root, element);
  {
    StoryEntity* created = (StoryEntity*) Factory::fabricate(element);
    if( created != NULL)
      this->addStoryEntity(created);
    PRINTF(4)("Created a new StoryEntity and added it to the Campaign: id=%i\n", created->getStoryID());
  }
  LOAD_PARAM_END_CYCLE(element);
}


/**
 *  add the StoryEntity to the campaign data tank
 * @param se the StoryEntity to add
 */
void CampaignData::addStoryEntity(StoryEntity* se)
{
  this->storyEntities.push_back(se);
}


/**
 *  switch to the next level in the list and return it
 */
StoryEntity* CampaignData::getFirstLevel()
{
  int                            nextStoryID;
  int                            storyID;
  list<StoryEntity*>::iterator   it;

  nextStoryID = 0;
  this->currentEntity = NULL;
  for( it = this->storyEntities.begin(); it != this->storyEntities.end(); it++)
  {
    storyID = (*it)->getStoryID();
    if( storyID == nextStoryID)
      this->currentEntity = (*it);
  }
  return this->currentEntity;
}


/**
 *  switch to the next level in the list and return it
 */
StoryEntity* CampaignData::getNextLevel()
{
  int                            nextStoryID;
  int                            storyID;
  list<StoryEntity*>::iterator   it;

  nextStoryID = this->currentEntity->getNextStoryID();
  this->currentEntity = NULL;
  for( it = this->storyEntities.begin(); it != this->storyEntities.end(); it++)
  {
    storyID = (*it)->getStoryID();
    if( storyID == nextStoryID)
      this->currentEntity = (*it);
  }
  return this->currentEntity;
}





