/*!
 * @file campaign.h
 * definition of the campaign
 */

#ifndef _CAMPAIGN_H
#define _CAMPAIGN_H


#include "story_entity.h"


class TiXmlElement;
class CampaignData;


//! A class that represents a game Campaign that contains other StoryEntities like GameWorlds, movies, etc.
class Campaign : public StoryEntity
{

  public:
    Campaign( TiXmlElement* root);
    virtual ~Campaign ();

    void loadParams(const TiXmlElement* root);

    virtual bool start();
    virtual bool stop();
    virtual bool pause();
    virtual bool resume();
    virtual void run();

    void switchToNextLevel();


  private:
    StoryEntity*                        currentEntity;          //!< reference to the current StoryEntity
    CampaignData*                       campaignData;           //!< reference to the CampaignData
};

#endif /* _CAMPAIGN_H */
