/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.


### File Specific:
   main-programmer: Silvan Nellen
   co-programmer: Benjamin Wuest
*/

#define DEBUG_MODULE_NETWORK

#include "synchronizeable.h"
#include "netdefs.h"
#include "network_manager.h"
#include "network_stream.h"


/**
 *  default constructor
 */
Synchronizeable::Synchronizeable()
{
  this->setClassID(CL_SYNCHRONIZEABLE, "Synchronizeable");
  owner = 0;
  state = 0;
  hostID = NetworkManager::getInstance()->getHostID();
  this->setIsServer(this->hostID == 0);
  uniqueID = -1;
  this->networkStream = NULL;
  this->setRequestedSync( false );
  this->setIsOutOfSync( !(this->isServer()) );
}



/**
 *  default destructor deletes all unneded stuff
 */
Synchronizeable::~Synchronizeable()
{
  if ( this->networkStream )
    this->networkStream->disconnectSynchronizeable(*this);
}

/**
 *  write data to NetworkStream
 */
int Synchronizeable::writeBytes(const byte* data, int length, int sender)
{
  PRINTF(5)("Synchronizeable::writeBytes was called\n");
}

/**
 *  read data from NetworkStream
 */
int Synchronizeable::readBytes(byte* data, int maxLength, int * reciever)
{
  PRINTF(5)("Synchronizeable::readBytes was called\n");
}


void Synchronizeable::writeDebug() const
{}


void Synchronizeable::readDebug() const
{}


/**
 * Sets the server flag to a given value
 * @param isServer: the boolean value which the server flag is to set to
 */
void Synchronizeable::setIsServer(bool isServer)
{
  if( isServer )
    this->state = this->state | STATE_SERVER;
  else
    this->state = this->state & (~STATE_SERVER);
}

/**
 * Sets the outofsync flag to a given value
 * @param outOfSync: the boolean value which the outofsync flag is to set to
 */
void Synchronizeable::setIsOutOfSync(bool outOfSync)
{
  if( outOfSync )
    this->state = this->state | STATE_OUTOFSYNC;
  else
    this->state = this->state & (~STATE_OUTOFSYNC);
  //PRINTF(0)("isoutofsync %s %d\n", this->getClassName(), state);
}

/**
 * Determines if the server flag is set
 * @return true, if the server flag is true, false else
 */
bool Synchronizeable::isServer()
{
  return (this->state & STATE_SERVER) >0;
}

/**
 * Determines if the outofsync flag is set
 * @return true, if the outofsync flag is true, false else
 */
bool Synchronizeable::isOutOfSync()
{
  return (this->state & STATE_OUTOFSYNC) >0;
}

/**
 * Determines if the requestedSync flag is set
 * @return true, if the requestedSync flag is true, false else
 */
bool Synchronizeable::requestedSync()
{
  return (this->state & STATE_REQUESTEDSYNC) >0;
}

/**
 * Sets the requestedsync flag to a given value
 * @param requestedSync: the boolean value which the requestedsync flag is to set to
 */
void Synchronizeable::setRequestedSync( bool requestedSync )
{
  if( requestedSync )
    this->state = this->state | STATE_REQUESTEDSYNC;
  else
    this->state = this->state & (~STATE_REQUESTEDSYNC);
}



