/*!
 * @file data_tank.h
 *  container for all data and data loadings. Its absolutily abstract and therefore generic.
 *  if there is something to load, this class will serve as a good base class since it
 *  gives you a basic structure for data loading
 */

#ifndef _DATA_TANK_H
#define _DATA_TANK_H


#include "base_object.h"
#include "error.h"


//! The DataTank
class DataTank : public BaseObject
{

  public:
    DataTank() {}
    virtual ~DataTank() {}

    /** initializes the DataTank to be able to load the data */
    virtual ErrorMessage init() {}
    /** loads the data into the DataTank @param root is the xml root parameter for for loadParams() connection */
    virtual ErrorMessage loadData(TiXmlElement* root = NULL) {}
    /** unloads the data again from the DataTank */
    virtual ErrorMessage unloadData() {}
};


#endif /* _DATA_TANK_H */
