/*!
 * @file proto_singleton.h
 * @brief Definition of the ... singleton Class
*/

#ifndef _PREFERENCES_H
#define _PREFERENCES_H

#include "base_object.h"
#include "multi_type.h"

// FORWARD DECLARATION


typedef struct {
  char* name;
  MultiType value;
} prefItem;

typedef struct {
  char* sectionName;
  std::list<prefItem> items;
} prefSection ;


//! A default singleton class.
class Preferences : public BaseObject {

 public:
   virtual ~Preferences(void);
  /** @returns a Pointer to the only object of this Class */
   inline static Preferences* getInstance(void) { if (!singletonRef) singletonRef = new Preferences();  return singletonRef; };

   //check if this entry exists
   bool exists(const char* section, const char* name);

   void setString(const char* section, const char* name, const char* value);
   void setInt(const char* section, const char* name, int value);
   void setFloat(const char* section, const char* name, float value);
   void setMultiType(const char* section, const char* name, const MultiType& value);

   const char* getString(const char* section, const char* name, const char* defaultValue);
   int getInt(const char* section, const char* name, int defaultValue);
   float getFloat(const char* section, const char* name, float defaultValue);
   MultiType getMultiType(const char* section, const char* name, const MultiType& defaultValue);


 private:
   Preferences(void);
   static Preferences* singletonRef;

   std::list<prefSection> data;
};

#endif /* _PREFERENCES_H */
