/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christoph Renner
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "preferences.h"

using namespace std;


/**
 * standard constructor
 */
Preferences::Preferences ()
{
   this->setClassID(CL_PREFERENCES, "Preferences");
   this->setName("Preferences");
}

/**
 *  the singleton reference to this class
 */
Preferences* Preferences::singletonRef = NULL;

/**
   @brief standard deconstructor
 */
Preferences::~Preferences ()
{
  Preferences::singletonRef = NULL;
}

/**
 * Check if this item exists
 * @param section name of the section
 * @param name name of the item to check
 * @return true if the item exists
 */
bool Preferences::exists(const char* section, const char* name)
{
  std::list<prefSection>::const_iterator it = data.begin();

  for ( ; it!=data.end(); it++)
  {
    if ( strcmp(it->sectionName, section) == 0 )
    {
      std::list<prefItem>::const_iterator it2 = it->items.begin();

      for ( ; it2!=it->items.begin(); it2++)
      {
        if ( strcmp(it2->name, name) == 0 )
          return true;
      }

      break;
    }
  }

  return false;
}

/**
 * Sets the value of an item. Creates it if doesn't exits.
 * @param section name of the section
 * @param name name of the item
 * @param value value
 */
void Preferences::setString(const char* section, const char* name, const char* value)
{
  setMultiType(section, name, MultiType(value));
}

/**
 * Sets the value of an item. Creates it if doesn't exits.
 * @param section name of the section
 * @param name name of the item
 * @param value value
 */
void Preferences::setInt(const char* section, const char* name, int value)
{
  setMultiType(section, name, MultiType(value));
}

/**
 * Sets the value of an item. Creates it if doesn't exits.
 * @param section name of the section
 * @param name name of the item
 * @param value value
 */
void Preferences::setFloat(const char* section, const char* name, float value)
{
  setMultiType(section, name, MultiType(value));
}

/**
 * Get the value of an item
 * @param section name of the section
 * @param name name of the item to check
 * @param defaultValue value to return if item doesn't exist
 * @return value of the item if found. defaultValue else
 */
const char* Preferences::getString(const char* section, const char* name, const char* defaultValue)
{
  return getMultiType(section, name, MultiType(defaultValue)).getString();
}

/**
 * Get the value of an item
 * @param section name of the section
 * @param name name of the item to check
 * @param defaultValue value to return if item doesn't exist
 * @return value of the item if found. defaultValue else
 */
int Preferences::getInt(const char* section, const char* name, int defaultValue)
{
  return getMultiType(section, name, MultiType(defaultValue)).getInt();
}

/**
 * Get the value of an item
 * @param section name of the section
 * @param name name of the item to check
 * @param defaultValue value to return if item doesn't exist
 * @return value of the item if found. defaultValue else
 */
float Preferences::getFloat(const char* section, const char* name, float defaultValue)
{
  return getMultiType(section, name, MultiType(defaultValue)).getFloat();
}

/**
 * Sets the value of an item. Creates it if doesn't exits.
 * @param section name of the section
 * @param name name of the item
 * @param value value
 */
void Preferences::setMultiType(const char* section, const char* name, const MultiType& value)
{
  std::list<prefSection>::iterator it = data.begin();

  for ( ; it!=data.end(); it++)
  {
    if ( strcmp(it->sectionName, section) == 0 )
    {
      std::list<prefItem>::iterator it2 = it->items.begin();

      for ( ; it2!=it->items.begin(); it2++)
      {
        if ( strcmp(it2->name, name) == 0 )
        {
          it2->value = value;
          return;
        }
      }
      prefItem item;
      item.value = value;
      item.name = new char[strlen(name)+1];
      strcpy( item.name, name );
      it->items.push_back(item);
      return;
    }
  }

  prefItem item;
  item.value = value;
  item.name = new char[strlen(name)+1];
  strcpy( item.name, name );

  prefSection sec;
  sec.items.push_back(item);
  sec.sectionName = new char[strlen(section)+1];
  strcpy( sec.sectionName, section );
  data.push_back( sec );
}

/**
 * Get the value of an item
 * @param section name of the section
 * @param name name of the item to check
 * @param defaultValue value to return if item doesn't exist
 * @return value of the item if found. defaultValue else
 */
MultiType Preferences::getMultiType(const char* section, const char* name,const MultiType& defaultValue)
{
  std::list<prefSection>::const_iterator it = data.begin();

  for ( ; it!=data.end(); it++)
  {
    if ( strcmp(it->sectionName, section) == 0 )
    {
      std::list<prefItem>::const_iterator it2 = it->items.begin();

      for ( ; it2!=it->items.begin(); it2++)
      {
        if ( strcmp(it2->name, name) == 0 )
        {
          return it2->value;
        }
      }

      break;
    }
  }

  return defaultValue;
}
