/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Benjamin Grauer

   2005-06-10: (bensch) added new sturcture to support multiple inheritance
*/

/*!
 * @file class_id.h
 * @brief list of orxonox ClassID's
 *
 *  this File is used to identify an Object with its class and also with its sub/super-classes.
 *  this is also used by the ObjectManager/Factory to identify and load important classes
 *
 *  !! important !!
 *  When adding a new CLASS be sure about the following:
 *    1. if it is a (SUB)SUPERCLASS make sure there is still space left (if not think of a new approach)
 *    2. check if the Number you add is not refered twice, and that with (SUB)SUPERCLASSES there are no intersections
 *    3. be sure to add you stuff in the right section, and don't interest yourself for the order of things. :)
 */

#ifndef _CLASS_ID_H
#define _CLASS_ID_H

//! list of all classes to be loadable in via the ObjectManager
/**
 *
 * -------------------------------------------------------------------------------------------
 * Consider the Identifiers 0xABCDEFGH
 * The first two: A and B are superclass Identifiers !! THEY ARE ALREADY FULL !!
 *
 * The second three are for sub-superclass-groups inheritance:
 *  C: a Group identifier: can be anything from 1,2,3,4,5,6,7,8,9,a,b,c,d,e,f,g,h
 *  D,E: Member within the Group, to specify further deriavtions within the Group.
 *       These may be anything from 1,2,4,8 (at D and E)
 *  !! consider, that you __may not__ have a derivated class from group a and group b.
 *
 * The last three entries F,G,H are for any leaf classes in existence.
 * they are ordered in the following way:
 *  F: LEAF-GroupSpecifier
 *  G,H: UNIQUE NUMBER eithin F-Group.
 *
 * You only have to extend the Class with your ClassID-tag.
 * If something goes Wrong, you get an Assertion-Warning in BaseObject.
 * !! Abstrace/Non-total-leaf classes do not have a LEAF-part.
 * -------------------------------------------------------------------------------------------
 *
 * COUNT:
 * -> # max SuperClass-count        = 7 (not intersecting)
 *    # max SubSuperClass-count     = 15*7 = 105 (the 7 classes will be able to get derived from each other, but not over the SubSuperClass.)
 *    # max lowerClasses-count      = 3^16 = enough (they are Leaves, and may NOT be derived by any other class.)
 */
typedef enum ClassID
{
  // the Nothing CLASS (NULL)
  CL_NULL                       =    0x00000000,

  // superclasses
  CL_MASK_SUPER_CLASS           =    0xff000000,
  CL_BASE_OBJECT                =    0x00000000,

  CL_PARENT_NODE                =    0x01000000,

  CL_STORY_ENTITY               =    0x02000000,

  CL_PHYSICS_INTERFACE          =    0x04000000,

  CL_EVENT_LISTENER             =    0x08000000,

  CL_ELEMENT_2D                 =    0x10000000,

  CL_SYNCHRONIZEABLE            =    0x20000000,

  CL_WORLD_ENTITY               =    0x40000000,

  // subsuper-classes derivations taken : 1, 2, 5, a, b, c.     << THIS IS A LIST OF ALL THE DCL_MASK_SUBSUPERCLASS_ID's taken

  // subsuper-classes
  CL_MASK_SUBSUPER_CLASS        =    0x00fff000,
  CL_MASK_SUBSUPER_CLASS_IDA    =    0x00f00000,
  CL_MASK_SUBSUPER_CLASS_IDB    =    0x000ff000,
  // SUPER-PNodes
  CL_FIELD                      =    0x00101000,
  // SUPER-WorldEntities
  CL_PLAYABLE                   =    0x00201000,
  CL_PLAYER                     =    0x00202000,
  CL_NPC                        =    0x00204000,
  CL_PROJECTILE                 =    0x00208000,
  CL_WEAPON                     =    0x00210000,
  CL_POWER_UP                   =    0x00220000,
  CL_EXTENDABLE                 =    0x00240000,
  // SUPER-Modeling
  CL_TEXTURE                    =    0x00c01000,
  CL_TEXT                       =    0x00c02000,

  CL_MODEL                      =    0x00d01000,
  CL_STATIC_MODEL               =    0x00002000,
  CL_VERTEX_ARRAY_MODEL         =    0x00004000,


  // subsuper-classes derivations taken : 1, 2, 5, a, b, c.     << THIS IS A LIST OF ALL THE DCL_MASK_SUBSUPERCLASS_ID's taken

  // lowest level classes
  CL_MASK_LOWLEVEL_CLASS        =    0x00000fff,

  // singleton classes (range from 0x00000f00 to 0x00000fff)
  CL_MASK_SINGLETON             =    0x00000f00,
  CL_ORXONOX                    =    0x00000f01,
  CL_NULL_PARENT                =    0x00000f02,
  CL_PILOT_PARENT               =    0x00000f03,
  CL_OBJECT_MANAGER             =    0x00000f04,
  CL_RESOURCE_MANAGER           =    0x00000f05,
  CL_GARBAGE_COLLECTOR          =    0x00000f06,
  CL_GAME_LOADER                =    0x00000f07,
  CL_GRAPHICS_ENGINE            =    0x00000f08,
  CL_TEXT_ENGINE                =    0x00000f09,
  CL_LIGHT_MANAGER              =    0x00000f0a,
  CL_EVENT_HANDLER              =    0x00000f0b,
  CL_PHYSICS_ENGINE             =    0x00000f0c,
  CL_CD_ENGINE                  =    0x00000f0d,
  CL_PARTICLE_ENGINE            =    0x00000f0e,
  CL_SOUND_ENGINE               =    0x00000f0f,
  CL_ANIMATION_PLAYER           =    0x00000f10,
  CL_TRACK_MANAGER              =    0x00000f11,
  CL_TRACK_NODE                 =    0x00000f12,
  CL_STATE                      =    0x00000f13,
  CL_FRAMEWORK                  =    0x00000f14,
  CL_RENDER_2D                  =    0x00000f21,
  CL_NULL_ELEMENT_2D            =    0x00000f22,
  CL_SHELL_BUFFER               =    0x00000f32,
  CL_GLGUI_HANDLER              =    0x00000f40,
  CL_GLGUI_MAIN_WIDGET          =    0x00000f41,
  CL_NETWORK_MANAGER            =    0x00000f50,
  CL_PREFERENCES                =    0X00000f51,



  // StoryEntities (range from 0x00000100 to 0x000001ff)
  CL_CAMPAIGN                   =    0x00000101,
  CL_WORLD                      =    0x00000102,


  // WorldEntities (range from 0x00000200 to 0x000004ff)
  CL_CAMERA                     =    0x00000201,
  CL_CAMERA_TARGET              =    0x00000202,

  CL_ENVIRONEMENT               =    0x00000203,
  CL_SATELLITE                  =    0x00000204,
  CL_SKYBOX                     =    0x00000205,
  CL_SKYSPHERE                  =    0x00000206,
  CL_TERRAIN                    =    0x00000207,
  CL_TEST_ENTITY                =    0x00000209,
  CL_SPACE_SHIP                 =    0x0000020a,
  CL_HELICOPTER                 =    0x0000020b,
  CL_SPAWNING_POINT             =    0x0000020c,
  CL_MD2_CREATURE               =    0x0000020d,

  CL_TURRET_POWER_UP            =    0x00000211,
  CL_LASER_POWER_UP             =    0x00000212,
  CL_WEAPON_POWER_UP            =    0x00000213,
  CL_PARAM_POWER_UP             =    0x00000214,

  CL_TEST_GUN                   =    0x00000230,
  CL_TURRET                     =    0x00000231,
  CL_AIMING_TURRET              =    0x00000232,
  CL_CANNON                     =    0x00000233,

  CL_TEST_BULLET                =    0x00000240,
  CL_ROCKET                     =    0x00000241,
  CL_LASER                      =    0x00000242,
  CL_BOMB                       =    0x00000243,
  CL_GROUND_TURRET              =    0x00000244,
  CL_GUIDED_MISSILE             =    0x00000245,

  CL_NPC_TEST1                  =    0x00000301,
  CL_NPC_TEST2                  =    0x00000302,


  // gamePlay (range from 0x00000500 0x000005ff)
  CL_EVENT                      =    0x00000501,
  CL_KEY_MAPPER                 =    0x00000502,
  CL_USER_CONTROL               =    0x00000511,
  CL_CROSSHAIR                  =    0x00000512,

  CL_WEAPON_MANAGER             =    0x00000503,

  // Physics stuff (range from 0x00000600 to 0x000007ff)
  CL_PHYSICS_CONNECTION         =    0x00000601,
  CL_FIELD_GRAVITY              =    0x00000610,
  CL_FIELD_POINT_GRAVITY        =    0x00000611,
  CL_FIELD_TWIRL                =    0x00000612,


  // Collision
  CL_COLLISION                  =    0x00000611,
  CL_BV_TREE                    =    0x00a01000,
  CL_BV_TREE_NODE               =    0x00002000,
  CL_OBB_TREE                   =    0x00000614,
  CL_OBB_TREE_NODE              =    0x00000615,
  CL_BOUNDING_VOLUME            =    0x00a10000,
  CL_OBB                        =    0x00020617,
  CL_BOUNDING_SPHERE            =    0x00040618,

  // graphical stuff (range from 0x00000800 to 0x000009ff)
  CL_FONT                       =    0x00000802,


  CL_MATERIAL                   =    0x00000804,
  CL_TEXTURE_SEQUENCE           =    0x00004805,
  CL_OBJ_MODEL                  =    0x00000807,
  CL_PROMITIVE_MODEL            =    0x00000808,
  CL_MD2Model                   =    0x00000809,
  CL_HEIGHT_MAP                 =    0x0000080a,
  CL_LIGHT                      =    0x00000811,
  CL_PARTICLE_EMITTER           =    0x00000812,
  CL_PARTICLE_SYSTEM            =    0x00000813,
  CL_ENVIRONMENT                =    0x00000821,
  CL_SHADER                     =    0x00000822,
  // GL-GUI
  CL_GLGUI_WIDGET               =    0x00500000,
  CL_GLGUI_BUTTON               =    0x00501000,
  CL_GLGUI_PUSHBUTTON           =    0x00000903,
  CL_GLGUI_CHECKBUTTON          =    0x00000904,
  CL_GLGUI_RADIOBUTTON          =    0x00000905,
  CL_GLGUI_CONTAINER            =    0x00002906,
  CL_GLGUI_BOX                  =    0x00000907,
  CL_GLGUI_FRAME                =    0x00000908,
  CL_GLGUI_WINDOW               =    0x00000909,
  CL_GLMENU_IMAGE_SCREEN        =    0x00000920,
  CL_GLGUI_BAR                  =    0x00000930,

  // sound stuff (range from 0x00000a00 to 0x00000aff)
  CL_SOUND_BUFFER               =    0x00000a01,
  CL_SOUND_SOURCE               =    0x00000a02,
  CL_SOUND_OGG_PLAYER           =    0x00000a11,


  // network stuff (range from 0x00000b00 to 0x00000bff)
  CL_DATA_STREAM                =    0x00b01b00,
  CL_NETWORK_STREAM             =    0x00000b01,
  CL_NETWORK_PROTOCOL           =    0x00000b02,
  CL_NETWORK_SOCKET             =    0x00000b03,
  CL_SERVER_SOCKET              =    0X00000b04,
  CL_CONNECTION_MONITOR         =    0x00000b05,
  CL_HANDSHAKE                  =    0x00000b06,
  CL_NETWORK_GAME_MANAGER       =    0x00000b07,



  // misc: (range from 0x00000d00 to 0x00000eff)
  CL_ANIMATION                  =    0x00000d01,
  //  CL_ANIMATION3D                =    0x00000b02,
  CL_QUICK_ANIMATION            =    0x00000d02,
  CL_FACTORY                    =    0x00000d03,
  CL_INI_PARSER                 =    0x00000d04,
  CL_LIST                       =    0x00000d05,
  CL_SUBSTRING                  =    0x00000d06,
  CL_LOAD_PARAM                 =    0x00000d07,
  CL_CURVE                      =    0x00000d08,
  CL_VECTOR                     =    0x00000d09,
  CL_CHARACTER_ATTRIBUTES       =    0x00000d0a,
  CL_TRACK_ELEMENT              =    0x00000d0b,
  CL_NUMBER                     =    0x00000d0c,
  CL_EXECUTOR                   =    0x00000d0d,
  CL_FAST_FACTORY               =    0x00000d01,
  CL_SHELL                      =    0x00000d10,
  CL_SHELL_COMMAND              =    0x00000d11,
  CL_SHELL_COMMAND_CLASS        =    0x00000d12,
  CL_SHELL_INPUT                =    0x00000d13,
  CL_SHELL_COMPLETION           =    0x00000d14,
  CL_SHELL_COMMAND_ALIAS        =    0x00000d15,

  // Spatial Data Separation
  CL_SPATIAL_SEPARATION         =    0x00000d0d,
  CL_QUADTREE                   =    0x00000d0e,
  CL_QUADTREE_NODE              =    0x00000d0f,
};


#endif /* _CLASS_ID_H */
