/*!
 * @file network_stream.h
 *  implementation of a network pipe
 */

#ifndef _NETWORK_STREAM
#define _NETWORK_STREAM

#include <vector>
#include <list>

#include "data_stream.h"
#include "network_protocol.h"
#include "server_socket.h"
#include "handshake.h"

#define MAX_CONNECTIONS 1000

class Synchronizeable;
class NetworkSocket;
class ServerSocket;
class ConnectionMonitor;
class NetworkProtocol;
class NetworkGameManager;

typedef std::list<Synchronizeable*>  SynchronizeableList;
typedef std::vector<NetworkSocket*>  NetworkSocketVector;
typedef std::vector<Handshake*>      HandshakeVector;


class NetworkStream : public DataStream
{

  public:
    NetworkStream();
    NetworkStream(IPaddress& address);
    NetworkStream(unsigned int port);

    ~NetworkStream();
    void init();

    void connectSynchronizeable(Synchronizeable& sync);
    void disconnectSynchronizeable(Synchronizeable& sync);

    inline bool isServer() const { return (this->type == NET_SERVER)? true:false; }
    inline bool isActive() const { return this->bActive; }

    inline int getMaxConnections(){ return maxConnections; }
    void setMaxConnections( int n );

    virtual void processData();

    inline SynchronizeableList::const_iterator getSyncBegin(){ return synchronizeables.begin(); }
    inline SynchronizeableList::const_iterator getSyncEnd(){ return synchronizeables.end(); }
    inline int getSyncCount(){ return synchronizeables.size(); }

  private:
    NetworkProtocol*       networkProtocol;
    ConnectionMonitor*     connectionMonitor;
    SynchronizeableList    synchronizeables;
    NetworkSocketVector    networkSockets;
    HandshakeVector        handshakes;
    ServerSocket*          serverSocket;
    int                    type;
    Header                 packetHeader;
    bool                   bActive;
    std::list<int>         freeSocketSlots;

    int                    myHostId;
    int                    maxConnections;

    NetworkGameManager*   networkGameManager;

    void updateConnectionList();
};
#endif /* _NETWORK_STREAM */
