/*!

*/

#ifndef _NETWORK_PROTOCOL_H
#define _NETWORK_PROTOCOL_H

/* include base_object.h since all classes are derived from this one */
#include "base_object.h"

/* include this file, it contains some default definitions */
#include "netdefs.h"

typedef struct Header
{
  int synchronizeableID;
  int length;
};

class Synchronizeable;

/*!

*/
class NetworkProtocol : virtual public BaseObject
{
  public:
    NetworkProtocol();
    ~NetworkProtocol();

    int createHeader(byte* data, int length, int bufferLength, const Synchronizeable& source);
    Header extractHeader(byte* data, int length);

  private:
    unsigned int headerLength; //The Length of the Header in bytes
};

#endif //_NETWORK_PROTOCOL_H
