/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Wuest
   co-programmer: ...
*/

/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

//#include ...

/* include my own header */
#include "network_protocol.h"

/* include the synchronizeable object */
#include "synchronizeable.h"

/* include this file for debugging */
#include "debug.h"

#include "converter.h"

/* using namespace std is default, this needs to be here */
using namespace std;


/**
  standard constructor
*/
NetworkProtocol::NetworkProtocol()
{
  /* set the class id for the base object */
  this->setClassID(CL_NETWORK_PROTOCOL, "NetworkProtocol");
  this->headerLength = INTSIZE+FLOATSIZE;
}

/**
  standard destructor
*/
NetworkProtocol::~NetworkProtocol()
{}

/**
    * creates a new packet header from the function arguments
    *
    * @arg data: the binary data without header -> return the data in this binary array
    * @arg length: the data length without header
    * @arg bufferLength: the length of the internal buffer
    * @arg source: reference to the source Synchronizeable object
    * @return: the new data length with header (the header data is included into byte* data)
    *          -1 if there isn't enough space in the buffer for the header
*/
int NetworkProtocol::createHeader(byte* data, int length, int bufferLength, const Synchronizeable& source)
{
  PRINTF(5)("create header length = %i, bufferLength = %i\n", length, bufferLength);
  //If there isn't enough space for the header return -1
  if (length + 2*INTSIZE > bufferLength)
    return -1;


  // FIXME: without move Create space for the header
  for( int i = length - 1; i >= 0; i--)
    data[i + INTSIZE+INTSIZE] = data[i];

  //Now create the header
  /* sender ID: FIXME: there will be a better ID (for example unique:D)*/
  //data[0] = (byte)(source.getUniqueID());
  int res = Converter::intToByteArray( source.getUniqueID(), data, bufferLength );

  /* data length*/
  //data[1] = length;
  res += Converter::intToByteArray( length, data+res, bufferLength-res );


  return length + res;
}

/**
    * extracts the header from the binary data stream
    * @arg data: the binary data with the header
    * @arg length: the length of the binary data (including header)
    * @return: a Header struct with the header information and the binary data
*/
Header NetworkProtocol::extractHeader(byte* data, int length)
{
  PRINTF(5)("extract Header\n");
  //Test if received data can contain a header
  if (length < 2*INTSIZE)
  {
    PRINTF(1)("Received data is to short; it can't contain a header!\n");
    Header h;
    h.length = 0;
    return h;
  }

  //Extract header
  Header h;
  //&h = data;

  /* unique ID */
  //h.synchronizeableID = data[0];
  int res = Converter::byteArrayToInt( data, &(h.synchronizeableID) );
  /* data length*/
  //h.length = data[1];
  Converter::byteArrayToInt( data+res, &(h.length) );


  return h;
}
