/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: christoph
   co-programmer:
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

#include "handshake.h"

Handshake::Handshake( bool server, int clientId, int networkGameManagerId )
{
  /* set the class id for the base object */
  this->setClassID(CL_HANDSHAKE, "Handshake");

  this->setIsServer(server);
  this->clientId = clientId;
  this->networkGameManagerId = networkGameManagerId;
  this->state = 0;
  this->isOk = false;
  this->setOwner(0);

  PRINTF(5)("Handshake created clientId = %d\n", clientId);
}

int Handshake::writeBytes( const byte * data, int length, int sender)
{
  PRINTF(5)("Handshake::writeBytes states = %d %d %d %d (%d)\n", hasState( HS_RECVD_INIT ), hasState( HS_RECVD_VER ), hasState( HS_RECVD_HID ), hasState( HS_COMPLETED ), state);

  SYNCHELP_READ_BEGIN();

  if ( hasState( HS_COMPLETED ) )
       return 0;

  if ( !hasState( HS_RECVD_INIT ) )
  {
    if ( length != _INITIAL_DATA_LENGTH )
    {
      PRINTF(0)("initial packet has wrong size %d instead of %d\n", length, _INITIAL_DATA_LENGTH);
      setState( HS_COMPLETED );
      return 0;
    }

    if ( strncmp((char*)data, _INITIAL_DATA, length) )
    {
      PRINTF(0)("initial packed does not match\n");
      setState( HS_COMPLETED );
      return length;
    }

    setState( HS_RECVD_INIT );
    PRINTF(0)("got valid initial packet from client %d\n", clientId);
    return length;
  }

  if ( hasState( HS_RECVD_INIT ) && !hasState( HS_RECVD_VER ) )
  {
    if ( length != _ORXONOX_VERSION_LENGTH )
    {
      PRINTF(0)("version number packet has wrong size %d instead of %d\n", length, _ORXONOX_VERSION_LENGTH);
      setState( HS_COMPLETED );
      return 0;
    }

    if ( strncmp((char*)data, _ORXONOX_VERSION, length) )
    {
      PRINTF(0)("versions do not match\n");
      setState( HS_COMPLETED );
      return length;
    }

    setState( HS_RECVD_VER );

    PRINTF(0)("client %d's version does match\n", clientId);
    return length;
  }

  if ( !isServer() && hasState( HS_RECVD_VER ) && !hasState( HS_RECVD_HID ) )
  {
    if ( length != INTSIZE+INTSIZE )
    {
      PRINTF(0)("hostID packet has wrong size %d instead of %d\n", length, 1);
      setState( HS_COMPLETED );
      return 0;
    }

    setState( HS_COMPLETED );
    setState( HS_RECVD_HID );
    this->isOk = true;
    SYNCHELP_READ_INT( this->newHostId );
    SYNCHELP_READ_INT( this->newNetworkGameManagerId );

    if ( newHostId == 0 )
    {
      setState( HS_WAS_REJECT );
      isOk = false;
      PRINTF(0)("Server did not accept handshake!\n");
    }
    else
    {
      PRINTF(0)("got my hostID: %d and networkGameManagerId: %d\n", newHostId, newNetworkGameManagerId);
    }
    return SYNCHELP_READ_N;
  }

}

int Handshake::readBytes( byte * data, int maxLength, int * reciever )
{
  PRINTF(5)("Handshake::readBytes states = %d %d %d %d (%d)\n", hasState( HS_SENT_INIT ), hasState( HS_SENT_VER ), hasState( HS_SENT_HID ), hasState( HS_COMPLETED ), state);

  SYNCHELP_WRITE_BEGIN();

  if ( hasState( HS_COMPLETED ) )
    return 0;

  if ( !hasState( HS_SENT_INIT ) )
  {
    if ( maxLength < _INITIAL_DATA_LENGTH )
    {
      PRINTF(0)("buffer too small for _INITIAL_DATA");
      setState( HS_COMPLETED );
      return 0;
    }

    setState( HS_SENT_INIT );
    memcpy(data, _INITIAL_DATA, _INITIAL_DATA_LENGTH);
    if ( this->isServer() )
      *reciever = clientId;
    return _INITIAL_DATA_LENGTH;
  }

  if ( hasState( HS_RECVD_INIT ) && hasState( HS_SENT_INIT ) && !hasState( HS_SENT_VER ) )
  {
    if ( maxLength < _ORXONOX_VERSION_LENGTH )
    {
      PRINTF(0)("buffer too small for version number");
      setState( HS_COMPLETED );
      return 0;
    }

    setState( HS_SENT_VER );
    memcpy(data, _ORXONOX_VERSION, _ORXONOX_VERSION_LENGTH);
    if ( this->isServer() )
      *reciever = clientId;
    return _ORXONOX_VERSION_LENGTH;
  }

  if ( isServer() && hasState( HS_RECVD_VER) && hasState( HS_SENT_VER ) && !hasState( HS_SENT_HID ) )
  {
    if ( maxLength < 2 )
    {
      PRINTF(0)("buffer too small for ID");
      setState( HS_COMPLETED );
      return 0;
    }

    setState( HS_SENT_HID );
    setState( HS_COMPLETED );

    if ( hasState( HS_DO_REJECT ) )
    {
      isOk = false;
      //memcpy(data, (byte*)0, 4);
      SYNCHELP_WRITE_INT( 0 );
      SYNCHELP_WRITE_INT( 0 );
    }
    else
    {
      isOk = true;
      //memcpy(data, &clientId, 4);
      SYNCHELP_WRITE_INT( clientId );
      SYNCHELP_WRITE_INT( networkGameManagerId );
    }
    *reciever = clientId;
    return SYNCHELP_WRITE_N;
  }

  return 0;
}

void Handshake::writeDebug( ) const
{
}

void Handshake::readDebug( ) const
{
}
