/*!
 * @file data_stream.h
  *  Main class for a data stream, used for our network stream
  *  network stream will get data, and will send it with a network socket
  *  to another network stream

*/

#ifndef _DATA_STREAM_H
#define _DATA_STREAM_H

#include "base_object.h"
#include "netdefs.h"

#define DATA_STREAM_BUFFER_SIZE 10240

class DataStream : public BaseObject
{
      public:
      DataStream();
      DataStream(DataStream& inStream, DataStream& outStream);
      ~DataStream();


      void connectUpStream(DataStream& upStream);

      void disconnectUpStream();

      void connectDownStream(DataStream& downStream);

      void disconnectDownStream();

      virtual void processData() = 0;

      protected:
      void passDown(byte* data, int length);

      int passUp(byte* data);

      byte* upBuffer;
      byte* downBuffer;
      unsigned int bufferSize;
      DataStream* upStream;
      DataStream* downStream;

};

#endif /* _DATA_STREAM_ */
