/*!
 * @file converter.h
 *  Is able to convert int to byte-array and vice versa
 */

#ifndef _CONVERTER
#define _CONVERTER

/* include this file, it contains some default definitions */
#include "netdefs.h"

/* include base_object.h since all classes are derived from this one */
#include "base_object.h"

/* The size of an int in byte */
#define INTSIZE 4
/* The size of a float in byte */
#define FLOATSIZE 4

/*!
 * a class that can convert int to byte-array and vice versa
 */
class Converter: public BaseObject
{
  public:
    static byte* intToByteArray(int x);
    static int byteArrayToInt(const byte* a);

    static int intToByteArray(int x, byte* a, int length);
    static int byteArrayToInt(const byte* a, int* x);

    static int floatToByteArray(float x, byte* a, int length);
    static int byteArrayToFloat(const byte* a, float* x);

    static int stringToByteArray(const char* s, byte* a, int length, int maxLength);
    static int byteArrayToString(const byte* a, char* s, int maxLength);
    static int byteArrayToStringM(const byte* a, char*& s );

    //Test
    static char* floatToBinString(float x);

    static byte* floatToByteArray(float x);
    static float byteArrayToFloat(byte* a);

    static byte* _floatToByteArray(float x);
    static float _byteArrayToFloat(byte* a);
  private:
    Converter();
    ~Converter();
};

#endif /*_CONVERTER*/
