/*!
 * @file vertex_array_model.h
 * @brief Contains the VertexArrayModel Class that handles 3D-Models rendered out of VertexArrays
 */

#ifndef _VERTEX_ARRAY_MODEL_H
#define _VERTEX_ARRAY_MODEL_H

#include "model.h"

#include "glincl.h"

#include "array.h"
#include <vector>

/* Forward Declaration */
class Material;


/////////////
/// MODEL ///
/////////////
//! Class that handles 3D-Models. it can also read them in and display them.
/**
 * this renders models with help of the OpenGL glVertexArray
 */
class VertexArrayModel : public Model
{
 public:
  VertexArrayModel();
  VertexArrayModel(const Model& model);
  virtual ~VertexArrayModel();

  void draw() const;


  void newStripe();

  void addVertex(float x, float y, float z);
  void addNormal(float x, float y, float z);
  void addTexCoor(float u, float v);
  void addIndice(GLubyte indice);

  void finalize();

  //
  void planeModel();

 private:
  void importToVertexArray();

 private:
  bool                       bFinalized;       //!< Sets the Object to be finalized.

  tArray<GLfloat>            vertices;        //!< The Array that handles the Vertices.
  tArray<GLfloat>            normals;         //!< The Array that handles the Normals.
  tArray<GLfloat>            texCoords;       //!< The Array that handles the VertexTextureCoordinates.

  tArray<GLubyte>            indices;         //!< The Array that tells us what Vertex is connected to which other one.

  std::vector<GLuint>        stripes;         //!< A lsit of Stripes of this Model.

};

#endif
